/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap;

import io.contextmap.ContextMapScannerMojo;
import io.contextmap.application.ResourceService;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.MojoParameters;
import io.contextmap.infrastructure.client.ContextMapServerClient;
import io.contextmap.model.Deployment;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="deployment", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class ContextMapDeploymentDocumenterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="key", required=true)
    private String key;
    @Parameter(property="systemName")
    private String systemName;
    @Parameter(property="multiModuleComponentName")
    private String multiModuleComponentName;
    @Parameter(property="version", required=true)
    private String version;
    @Parameter(property="environment", required=true)
    private String environment;

    public void execute() throws MojoExecutionException {
        MojoLogger.initLogger(this.getLog());
        MojoParameters parameters = this.createParameters();
        if (!parameters.isMultiModuleProject() || parameters.isRootModule()) {
            MojoLogger.logger.info("Documenting deployment of " + this.version + " to " + this.environment);
            this.documentDeployment(parameters);
            MojoLogger.logger.info("Finished documenting deployment.");
        } else {
            MojoLogger.logger.debug("Skip deployment documentation for non root module");
        }
    }

    private void documentDeployment(MojoParameters parameters) {
        try {
            ContextMapServerClient client = new ContextMapServerClient(parameters);
            Deployment deploymentInfo = this.createDeployment(parameters);
            client.documentDeployment(deploymentInfo);
        }
        catch (Exception e) {
            MojoLogger.logger.error("Sending failed", e);
        }
    }

    private MojoParameters createParameters() {
        MojoParameters parameters = new MojoParameters();
        parameters.setKey(this.key);
        parameters.setSystemName(this.systemName);
        if (this.multiModuleComponentName != null && this.multiModuleComponentName.length() > 0) {
            parameters.setMultiModuleComponentName(this.multiModuleComponentName);
            parameters.setRootModule(ContextMapScannerMojo.isRootOfModules(this.project));
        }
        return parameters;
    }

    private Deployment createDeployment(MojoParameters parameters) {
        Deployment deployment = new Deployment();
        deployment.version = this.version;
        deployment.environment = this.environment;
        if (parameters.isMultiModuleProject()) {
            deployment.componentName = parameters.getMultiModuleComponentName();
        } else {
            ResourceService resourceService = new ResourceService(parameters);
            ConfigurationResource configResource = resourceService.scanConfiguration(this.project);
            deployment.componentName = configResource.getName();
        }
        return deployment;
    }
}

