/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.annotations.client.ContextClient;
import io.contextmap.annotations.client.ContextClients;
import io.contextmap.application.ReflectionService;
import io.contextmap.application.endpoints.EndpointReflection;
import io.contextmap.application.endpoints.SpEL;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SubscribedEndpointService {
    private static final String LOAD_BALANCER_CLIENT = "org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient";
    private static final String LOAD_BALANCER_CLIENTS = "org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients";
    private static final String[] classesUsedSubscribedEndpoints = new String[]{"org.springframework.cloud.openfeign.FeignClient", "org.springframework.cloud.netflix.feign.FeignClient", ContextClient.class.getName(), ContextClients.class.getName(), "org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient", "org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients"};
    private final ReflectionService reflectionService;

    public SubscribedEndpointService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<RestApiEndpoint> scan() {
        try {
            ArrayList<RestApiEndpoint> apis = new ArrayList<RestApiEndpoint>();
            apis.addAll(this.getRestApiEndpointsFromMethodAnnotations());
            apis.addAll(this.getRestApiEndpointsFromClassAnnotations());
            return apis;
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for subscribed endpoints");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private List<RestApiEndpoint> getRestApiEndpointsFromClassAnnotations() throws Exception {
        Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedSubscribedEndpoints);
        return classes.stream().flatMap(type -> this.toEndpoints((Class<?>)type).stream()).collect(Collectors.toList());
    }

    private List<RestApiEndpoint> getRestApiEndpointsFromMethodAnnotations() throws Exception {
        ArrayList<RestApiEndpoint> endpoints = new ArrayList<RestApiEndpoint>();
        Set<Method> methodsForGroup = this.reflectionService.scanForMethodsAnnotatedWith(new String[]{ContextClients.class.getName()});
        for (Method method2 : methodsForGroup) {
            ContextClients ctxClients = this.reflectionService.getAnnotation(method2, ContextClients.class.getName()).orElse(null);
            if (ctxClients == null) continue;
            endpoints.addAll(this.createFixedEndpointsForContextClients(ctxClients));
        }
        Set<Method> methods = this.reflectionService.scanForMethodsAnnotatedWith(new String[]{ContextClient.class.getName()});
        methods.stream().map(method -> this.reflectionService.getAnnotation((Method)method, ContextClient.class.getName()).map(this::createFixedEndpointForContextClient).orElse(null)).filter(Objects::nonNull).forEach(endpoints::add);
        return endpoints;
    }

    private List<RestApiEndpoint> toEndpoints(Class<?> type) {
        String pathPrefix = this.getClientPath(type);
        MojoLogger.logger.debug("Type " + type.getSimpleName() + " has general path " + pathPrefix);
        EndpointReflection endpointReflection = new EndpointReflection(this.reflectionService);
        List<RestApiEndpoint> endpoints = endpointReflection.getEndpoints(type, pathPrefix);
        String componentName = this.getComponentName(type);
        endpoints.forEach(e -> {
            e.componentName = componentName;
            e.actual = true;
        });
        if (endpoints.isEmpty()) {
            this.reflectionService.getAnnotation(type, LOAD_BALANCER_CLIENT).ifPresent(annotation -> endpoints.addAll(this.createEndpointsForLoadBalancerClient((Annotation)annotation)));
            this.reflectionService.getAnnotation(type, LOAD_BALANCER_CLIENTS).ifPresent(annotation -> endpoints.addAll(this.createEndpointsForLoadBalancerClients((Annotation)annotation)));
        }
        if (endpoints.isEmpty()) {
            this.reflectionService.getAnnotation(type, ContextClient.class.getName()).ifPresent(annotation -> endpoints.add(this.createFixedEndpointForContextClient((Annotation)annotation)));
            this.reflectionService.getAnnotation(type, ContextClients.class.getName()).ifPresent(annotation -> endpoints.addAll(this.createFixedEndpointsForContextClients((ContextClients)annotation)));
        }
        return endpoints;
    }

    public RestApiEndpoint createAnonymousEndpoint(String componentName) {
        RestApiEndpoint endpoint = new RestApiEndpoint();
        endpoint.path = "/";
        endpoint.requestMethod = "GET";
        endpoint.componentName = componentName;
        endpoint.actual = false;
        return endpoint;
    }

    private RestApiEndpoint createFixedEndpointForContextClient(Annotation contextClientAnnotation) {
        String componentName = this.getValueNameOrServiceIdFromAnnotation(contextClientAnnotation);
        return this.createAnonymousEndpoint(componentName);
    }

    private List<RestApiEndpoint> createFixedEndpointsForContextClients(ContextClients contextClientsAnnotation) {
        return Arrays.stream(contextClientsAnnotation.value()).map(this::createFixedEndpointForContextClient).collect(Collectors.toList());
    }

    private List<RestApiEndpoint> createEndpointsForLoadBalancerClient(Annotation annotation) {
        String componentName = this.getValueNameOrServiceIdFromAnnotation(annotation);
        RestApiEndpoint endpoint = new RestApiEndpoint();
        endpoint.path = "/";
        endpoint.requestMethod = "GET";
        endpoint.componentName = componentName;
        endpoint.actual = false;
        return Collections.singletonList(endpoint);
    }

    private List<RestApiEndpoint> createEndpointsForLoadBalancerClients(Annotation annotation) {
        ArrayList<RestApiEndpoint> endpoints = new ArrayList<RestApiEndpoint>();
        try {
            this.reflectionService.getAnnotationFieldValue(annotation, "value").ifPresent(clients -> {
                Annotation[] clientAnnotations = (Annotation[])clients;
                Arrays.stream(clientAnnotations).flatMap(a -> this.createEndpointsForLoadBalancerClient((Annotation)a).stream()).forEach(endpoints::add);
            });
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for load balancer clients");
            MojoLogger.logger.debug("Exception", e);
        }
        return endpoints;
    }

    private String getClientPathFromHttpExchange(Class<?> type) {
        String annotationName = "org.springframework.web.service.annotation.HttpExchange";
        Annotation httpExchangeAnnotation = this.reflectionService.getAnnotation(type, annotationName).orElse(null);
        if (httpExchangeAnnotation == null) {
            return "";
        }
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(httpExchangeAnnotation, "value");
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(httpExchangeAnnotation, "url");
        }
        return result.map(value -> {
            try {
                return (String)value;
            }
            catch (ClassCastException e) {
                return "";
            }
        }).orElse("");
    }

    private String getClientPath(Class<?> type) {
        String path = Arrays.stream(classesUsedSubscribedEndpoints).map(annotationName -> this.reflectionService.getAnnotation(type, (String)annotationName).orElse(null)).filter(Objects::nonNull).findFirst().map(this::getPathFromAnnotation).orElse("");
        if (path.isEmpty()) {
            path = this.getClientPathFromHttpExchange(type);
        }
        return path;
    }

    private String getComponentName(Class<?> type) {
        return Arrays.stream(classesUsedSubscribedEndpoints).map(feignClientType -> this.reflectionService.getAnnotation(type, (String)feignClientType).orElse(null)).filter(Objects::nonNull).findFirst().map(this::getValueNameOrServiceIdFromAnnotation).map(SpEL::extractDefaultValue).orElse("");
    }

    private String getPathFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "path");
        return result.map(value -> (String)value).orElse("");
    }

    private String getValueNameOrServiceIdFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "name");
        }
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "serviceId");
        }
        return result.map(value -> {
            try {
                return (String)value;
            }
            catch (ClassCastException e) {
                return "";
            }
        }).orElse("");
    }
}

