/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.annotations.ContextGlossary;
import io.contextmap.application.ReflectionService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.GlossaryTerm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GlossaryService {
    private final ReflectionService reflectionService;

    public GlossaryService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<GlossaryTerm> scan() {
        try {
            String[] classesUsedByGlossaryTerms = new String[]{ContextGlossary.class.getName()};
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedByGlossaryTerms);
            return this.scanClasses(classes);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for glossary terms");
            return Collections.emptyList();
        }
    }

    private List<GlossaryTerm> scanClasses(Collection<Class<?>> classes) {
        return classes.stream().map(this::toGlossaryTerm).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<GlossaryTerm> toGlossaryTerm(Class<?> type) {
        GlossaryTerm term = new GlossaryTerm();
        term.name = type.getSimpleName();
        this.reflectionService.getAnnotation(type, ContextGlossary.class.getName()).ifPresent(annotation -> {
            ContextGlossary contextGlossary = (ContextGlossary)annotation;
            String specificName = contextGlossary.name();
            if (specificName != null && !specificName.isEmpty()) {
                term.name = specificName;
            }
            term.definition = contextGlossary.value();
            term.aliases = Arrays.asList(contextGlossary.aliases());
        });
        if (term.name == null || term.name.isEmpty() || term.definition == null || term.definition.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(term);
    }
}

