/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.ReflectionService;
import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import io.contextmap.model.RestApiEndpointGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PublishedEndpointFromRoutesService {
    private static final String annotationType = "org.springdoc.core.annotations.RouterOperations";
    private final ReflectionService reflectionService;

    public PublishedEndpointFromRoutesService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<RestApiEndpointGroup> scan() {
        return this.scanFromRoutes();
    }

    private List<RestApiEndpointGroup> scanFromRoutes() {
        try {
            Set<Method> methods = this.reflectionService.scanForMethodsAnnotatedWith(new String[]{annotationType});
            ArrayList<RestApiEndpointGroup> restApiEndpointGroups = new ArrayList<RestApiEndpointGroup>();
            for (Method method : methods) {
                List<RestApiEndpoint> endpoints = this.toEndpoints(method);
                if (endpoints.isEmpty()) continue;
                RestApiEndpointGroup group = this.initRestApiEndpointGroup(method);
                group.endpoints = endpoints;
                restApiEndpointGroups.add(group);
            }
            return restApiEndpointGroups;
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for published endpoints from routes");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private RestApiEndpointGroup initRestApiEndpointGroup(Method method) {
        RestApiEndpointGroup group = new RestApiEndpointGroup();
        group.dataType = method.getName();
        group.name = null;
        group.description = null;
        return group;
    }

    private List<RestApiEndpoint> toEndpoints(Method method) {
        Optional<Annotation> annotationOptional = this.reflectionService.getAnnotation(method, annotationType);
        if (!annotationOptional.isPresent()) {
            return Collections.emptyList();
        }
        Annotation annotation = annotationOptional.get();
        Optional<Object> value = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        Annotation[] routes = (Annotation[])value.get();
        return Arrays.stream(routes).flatMap(route -> {
            Optional<Object> path = this.reflectionService.getAnnotationFieldValue((Annotation)route, "path");
            Optional<Object> methods = this.reflectionService.getAnnotationFieldValue((Annotation)route, "method");
            if (!methods.isPresent() || ((Object[])methods.get()).length == 0) {
                RestApiEndpoint endpoint = new RestApiEndpoint();
                endpoint.requestMethod = "GET";
                this.enrichEndpoint(endpoint, (Annotation)route);
                return Collections.singletonList(endpoint).stream();
            }
            return Arrays.stream((Object[])methods.get()).map(m -> (Enum)m).map(Enum::name).map(rm -> {
                RestApiEndpoint endpoint = new RestApiEndpoint();
                endpoint.requestMethod = rm;
                this.enrichEndpoint(endpoint, (Annotation)route);
                return endpoint;
            }).collect(Collectors.toList()).stream();
        }).collect(Collectors.toList());
    }

    private void enrichEndpoint(RestApiEndpoint endpoint, Annotation route) {
        Optional<Object> path = this.reflectionService.getAnnotationFieldValue(route, "path");
        endpoint.path = path.map(p -> (String)p).orElse("");
        Optional<Object> operation = this.reflectionService.getAnnotationFieldValue(route, "operation");
        if (operation.isPresent()) {
            Annotation requestBodyAnnotation;
            Optional<Object> content;
            Optional<Object> requestBody;
            Annotation[] responsesAnnotations;
            Optional<Object> content2;
            Annotation operationAnnotation = (Annotation)operation.get();
            String descr = (String)this.reflectionService.getAnnotationFieldValue(operationAnnotation, "summary").orElse("");
            if (descr.length() == 0) {
                descr = (String)this.reflectionService.getAnnotationFieldValue(operationAnnotation, "description").orElse("");
            }
            endpoint.description = descr;
            Optional<Object> parameters = this.reflectionService.getAnnotationFieldValue(operationAnnotation, "parameters");
            if (parameters.isPresent() && ((Object[])parameters.get()).length > 0) {
                endpoint.requestParameters = new ArrayList();
                Arrays.stream((Object[])parameters.get()).map(p -> (Annotation)p).forEach(param -> {
                    Enum en;
                    Optional<Object> in = this.reflectionService.getAnnotationFieldValue((Annotation)param, "in");
                    if (in.isPresent() && ((en = (Enum)in.get()).name().equals("DEFAULT") || en.name().equals("QUERY"))) {
                        RestApiEndpoint.RequestParameter rp = new RestApiEndpoint.RequestParameter();
                        rp.name = (String)this.reflectionService.getAnnotationFieldValue((Annotation)param, "name").orElse("");
                        rp.optional = (Boolean)this.reflectionService.getAnnotationFieldValue((Annotation)param, "required").orElse(false) == false;
                        endpoint.requestParameters.add(rp);
                    }
                });
            }
            endpoint.deprecated = (Boolean)this.reflectionService.getAnnotationFieldValue(operationAnnotation, "deprecated").orElse(false);
            Optional<Object> responses = this.reflectionService.getAnnotationFieldValue(operationAnnotation, "responses");
            if (responses.isPresent() && ((Object[])responses.get()).length > 0 && (content2 = this.reflectionService.getAnnotationFieldValue((responsesAnnotations = (Annotation[])responses.get())[0], "content")).isPresent() && ((Object[])content2.get()).length > 0) {
                Annotation[] contentAnnotation = (Annotation[])content2.get();
                this.getClassFromContent(contentAnnotation[0]).ifPresent(implementationType -> {
                    Property property = new Property("", null, null, null, implementationType);
                    List typesToExcludeToPreventLoop = Collections.emptyList();
                    endpoint.responseBodyJsonNode = new ObjectToJsonConverter((ObjectToJsonConverter.ObjectToJsonReflection)this.reflectionService, (ObjectToJsonConverter.ObjectToJsonLogger)MojoLogger.logger).serializedJson(implementationType, property, typesToExcludeToPreventLoop);
                });
            }
            if ((requestBody = this.reflectionService.getAnnotationFieldValue(operationAnnotation, "requestBody")).isPresent() && (content = this.reflectionService.getAnnotationFieldValue(requestBodyAnnotation = (Annotation)requestBody.get(), "content")).isPresent() && ((Object[])content.get()).length > 0) {
                Annotation[] contentAnnotation = (Annotation[])content.get();
                this.getClassFromContent(contentAnnotation[0]).ifPresent(implementationType -> {
                    Property property = new Property("", null, null, null, implementationType);
                    List typesToExcludeToPreventLoop = Collections.emptyList();
                    endpoint.requestBodyJsonNode = new ObjectToJsonConverter((ObjectToJsonConverter.ObjectToJsonReflection)this.reflectionService, (ObjectToJsonConverter.ObjectToJsonLogger)MojoLogger.logger).deserializedJson(implementationType, property, typesToExcludeToPreventLoop);
                });
            }
        }
    }

    private Optional<Class<?>> getClassFromContent(Annotation contentAnnotation) {
        Annotation schemaAnnotation;
        Optional<Object> implementation;
        Optional<Object> schema = this.reflectionService.getAnnotationFieldValue(contentAnnotation, "schema");
        if (schema.isPresent() && (implementation = this.reflectionService.getAnnotationFieldValue(schemaAnnotation = (Annotation)schema.get(), "implementation")).isPresent() && !Void.TYPE.equals(implementation.get()) && !Void.class.equals(implementation.get())) {
            return Optional.of((Class)implementation.get());
        }
        return Optional.empty();
    }
}

