/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.annotations.rest.ContextRestApi;
import io.contextmap.application.PublishedEndpointFromRestDocsService;
import io.contextmap.application.PublishedEndpointFromRoutesService;
import io.contextmap.application.ReflectionService;
import io.contextmap.application.endpoints.EndpointReflection;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import io.contextmap.model.RestApiEndpointGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PublishedEndpointService {
    private static final String[] classesUsedPublishedEndpoints = new String[]{"org.springframework.web.bind.annotation.RestController", "org.springframework.stereotype.Controller"};
    private final ReflectionService reflectionService;

    public PublishedEndpointService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<RestApiEndpointGroup> scan(Path baseDir) {
        ArrayList<RestApiEndpointGroup> results = new ArrayList<RestApiEndpointGroup>();
        results.addAll(this.scanFromAnnotatedMethods());
        results.addAll(this.scanFromOpenApiRoutes());
        if (results.isEmpty()) {
            results.addAll(this.scanFromRestDocs(baseDir));
        }
        return results;
    }

    private List<RestApiEndpointGroup> scanFromRestDocs(Path baseDir) {
        PublishedEndpointFromRestDocsService restDocsScanner = new PublishedEndpointFromRestDocsService();
        List<RestApiEndpoint> restDocsApis = restDocsScanner.scan(baseDir);
        if (!restDocsApis.isEmpty()) {
            RestApiEndpointGroup group = new RestApiEndpointGroup();
            group.dataType = "";
            group.name = null;
            group.description = null;
            group.endpoints = restDocsApis;
            return Collections.singletonList(group);
        }
        return Collections.emptyList();
    }

    private List<RestApiEndpointGroup> scanFromOpenApiRoutes() {
        PublishedEndpointFromRoutesService routesService = new PublishedEndpointFromRoutesService(this.reflectionService);
        return routesService.scan();
    }

    private List<RestApiEndpointGroup> scanFromAnnotatedMethods() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedPublishedEndpoints);
            ArrayList<RestApiEndpointGroup> restApiEndpointGroups = new ArrayList<RestApiEndpointGroup>();
            for (Class clazz : classes) {
                List<RestApiEndpoint> endpoints = this.toEndpoints(clazz);
                if (endpoints.isEmpty()) continue;
                RestApiEndpointGroup group = this.initRestApiEndpointGroup(clazz);
                group.endpoints = endpoints;
                restApiEndpointGroups.add(group);
            }
            return restApiEndpointGroups;
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for published endpoints");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private RestApiEndpointGroup initRestApiEndpointGroup(Class<?> type) {
        RestApiEndpointGroup group = new RestApiEndpointGroup();
        group.dataType = type.getSimpleName();
        group.name = null;
        group.description = null;
        this.reflectionService.getAnnotation(type, ContextRestApi.class.getName()).ifPresent(annotation -> {
            group.name = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "name").orElse(null);
            group.description = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "description").orElse(null);
        });
        this.reflectionService.getAnnotation(type, "io.swagger.v3.oas.annotations.tags.Tag").ifPresent(annotation -> {
            group.name = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "name").orElse(null);
            group.description = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "description").orElse(null);
        });
        this.reflectionService.getAnnotation(type, "io.swagger.annotations.Api").ifPresent(annotation -> {
            group.name = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value").orElse(null);
            group.description = this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "description").orElse(null);
        });
        return group;
    }

    private List<RestApiEndpoint> toEndpoints(Class<?> type) {
        EndpointReflection endpointReflection = new EndpointReflection(this.reflectionService);
        String pathPrefix = this.getRestControllerPath(type, endpointReflection);
        MojoLogger.logger.debug("Type " + type.getSimpleName() + " has general path " + pathPrefix);
        return endpointReflection.getEndpoints(type, pathPrefix);
    }

    private String getRestControllerPath(Class<?> type, EndpointReflection endpointReflection) {
        String requestMappingType = "org.springframework.web.bind.annotation.RequestMapping";
        Annotation requestMappingAnnotation = this.reflectionService.getAnnotation(type, requestMappingType).orElse(null);
        if (requestMappingAnnotation == null) {
            Annotation[] annotations;
            for (Annotation ann : annotations = type.getAnnotations()) {
                Method[] methods;
                boolean isAnnotationWhichExtendsRequestMapping;
                boolean bl = isAnnotationWhichExtendsRequestMapping = Arrays.stream(ann.annotationType().getAnnotations()).filter(a -> a.annotationType().getName().equals(requestMappingType)).count() > 0L;
                if (!isAnnotationWhichExtendsRequestMapping) continue;
                for (Method method : methods = ann.annotationType().getDeclaredMethods()) {
                    Annotation[] methodAnnotations;
                    for (Annotation methodAnnotation : methodAnnotations = method.getAnnotations()) {
                        boolean isAliasForRequestMapping;
                        if (!methodAnnotation.annotationType().getName().equals("org.springframework.core.annotation.AliasFor")) continue;
                        Optional<Object> annotationFieldValue = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "annotation");
                        boolean bl2 = isAliasForRequestMapping = annotationFieldValue.isPresent() && annotationFieldValue.get() instanceof Class && ((Class)annotationFieldValue.get()).getName().equals(requestMappingType);
                        if (!isAliasForRequestMapping) continue;
                        String attribute = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "attribute").map(String::valueOf).orElse("");
                        if (!"path".equals(attribute) && !"value".equals(attribute)) {
                            attribute = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "value").map(String::valueOf).orElse("");
                        }
                        if (!"path".equals(attribute) && !"value".equals(attribute)) continue;
                        try {
                            return String.valueOf(method.invoke((Object)ann, new Object[0]));
                        }
                        catch (Exception e) {
                            MojoLogger.logger.warn("Unable to get value of annotation");
                        }
                    }
                }
            }
            return "";
        }
        return endpointReflection.getPathOrValueFromAnnotation(requestMappingAnnotation);
    }
}

