/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.google.common.collect.Streams;
import io.contextmap.annotations.capability.ContextCapabilities;
import io.contextmap.annotations.capability.ContextCapability;
import io.contextmap.application.ReflectionService;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.MojoParameters;
import io.contextmap.model.Capability;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CapabilityService {
    private final ReflectionService reflectionService;
    private final MojoParameters parameters;
    private static final String classUsedByCapability = ContextCapability.class.getName();
    private static final String groupclassUsedByCapability = ContextCapabilities.class.getName();

    public CapabilityService(MojoParameters parameters, ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
        this.parameters = parameters;
    }

    public List<Capability> scan(ConfigurationResource configResource) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.addAll(this.scanCapabilitiesBasedOnAnnotations());
        capabilities.addAll(this.scanCapabilitiesBasedOnProperties(configResource));
        capabilities.addAll(this.scanCapabilitiesBasedOnMavenPom());
        return capabilities;
    }

    private List<Capability> scanCapabilitiesBasedOnAnnotations() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(new String[]{classUsedByCapability, groupclassUsedByCapability});
            return this.scanClasses(classes);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for entities");
            return Collections.emptyList();
        }
    }

    private List<Capability> scanCapabilitiesBasedOnProperties(ConfigurationResource configResource) {
        List<Capability> capabilities = configResource.getCapabilities();
        if (capabilities == null) {
            return Collections.emptyList();
        }
        return capabilities;
    }

    private List<Capability> scanCapabilitiesBasedOnMavenPom() {
        if (this.parameters.getCapabilities() == null) {
            return Collections.emptyList();
        }
        return this.parameters.getCapabilities().stream().filter(name -> name != null && name.length() > 0).map(this::createCapability).collect(Collectors.toList());
    }

    private List<Capability> scanClasses(Collection<Class<?>> classes) {
        Stream<Annotation> capabilityAnnotations = classes.stream().map(clazz -> this.reflectionService.getAnnotation((Class<?>)clazz, classUsedByCapability)).filter(Optional::isPresent).map(Optional::get);
        Stream capabilityGroupAnnotations = classes.stream().map(clazz -> this.reflectionService.getAnnotation((Class<?>)clazz, groupclassUsedByCapability)).filter(Optional::isPresent).map(Optional::get).map(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).filter(Optional::isPresent).map(Optional::get).flatMap(value -> Arrays.stream((ContextCapability[])value));
        Stream annotationsFromSinglesAndGroups = Streams.concat((Stream[])new Stream[]{capabilityAnnotations, capabilityGroupAnnotations});
        Stream<String> capabilityNames = annotationsFromSinglesAndGroups.map(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).filter(Optional::isPresent).map(Optional::get).map(String.class::cast).filter(name -> name.length() > 0).distinct();
        return capabilityNames.map(this::createCapability).collect(Collectors.toList());
    }

    private Capability createCapability(String name) {
        Capability capability = new Capability();
        capability.name = name;
        return capability;
    }
}

