/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.annotations.entity.ContextSoftLink;
import io.contextmap.application.ReflectionService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.DomainObject;
import io.contextmap.model.Field;
import io.contextmap.model.SoftLink;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityService {
    private static final int MAX_NR_OF_ENTITIES = 100;
    private static final String[] classesUsedByEntities = new String[]{"javax.persistence.Entity", "javax.persistence.MappedSuperclass", "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document", "org.springframework.data.redis.core.RedisHash", "org.springframework.data.cassandra.core.mapping.Table", "org.springframework.data.neo4j.core.schema.Node", "io.contextmap.annotations.ContextAggregateRoot", "io.contextmap.annotations.ContextEntity", "com.microsoft.azure.spring.data.cosmosdb.core.mapping.Document", "com.azure.spring.data.cosmos.core.mapping.Container"};
    private static final String[] classesUsedByEntitiesWhereFieldsAreAutomaticallyEntities = new String[]{"org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document", "com.microsoft.azure.spring.data.cosmosdb.core.mapping.Document", "com.azure.spring.data.cosmos.core.mapping.Container", "io.contextmap.annotations.ContextAggregateRoot"};
    private static final Set<String> classesSeenAsAggregateRoot = new HashSet<String>(Arrays.asList("io.contextmap.annotations.ContextAggregateRoot", "org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document", "com.microsoft.azure.spring.data.cosmosdb.core.mapping.Document", "com.azure.spring.data.cosmos.core.mapping.Container"));
    private final ReflectionService reflectionService;

    public EntityService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<DomainObject> scan() {
        try {
            HashSet classes = new HashSet();
            Set<Class<?>> classesFromEntities = this.reflectionService.scanForClassesAnnotatedWith(classesUsedByEntities);
            classes.addAll(classesFromEntities);
            Set<Class<?>> classesFromNestedEntities = this.getClassesWithFieldsThatShouldAlsoBeIncluded();
            classes.addAll(classesFromNestedEntities);
            return this.scanClasses(classes);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for entities");
            return Collections.emptyList();
        }
    }

    private Set<Class<?>> getClassesWithFieldsThatShouldAlsoBeIncluded() throws Exception {
        Set<Class<?>> classesToGetNestedFieldsOf = this.reflectionService.scanForClassesAnnotatedWith(classesUsedByEntitiesWhereFieldsAreAutomaticallyEntities);
        if (classesToGetNestedFieldsOf.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList classesToProcess = new ArrayList(classesToGetNestedFieldsOf);
        HashSet entityClasses = new HashSet();
        HashSet<Class> processedClasses = new HashSet<Class>();
        while (!classesToProcess.isEmpty()) {
            Class classToProcess = (Class)classesToProcess.remove(0);
            processedClasses.add(classToProcess);
            if (!classToProcess.isEnum()) {
                entityClasses.add(classToProcess);
            }
            Arrays.stream(classToProcess.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).forEach(field -> {
                if (field.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                    Type[] parameterTypes = parameterizedType.getActualTypeArguments();
                    List<Object> parameterClasses = new ArrayList();
                    if (parameterTypes != null) {
                        parameterClasses = Arrays.stream(parameterTypes).filter(pt -> pt instanceof Class).map(pt -> (Class)pt).collect(Collectors.toList());
                    }
                    parameterClasses.stream().filter(cl -> !processedClasses.contains(cl)).forEach(cl -> {
                        if (this.reflectionService.isClassInSourceDirectory((Class<?>)cl)) {
                            classesToProcess.add((Class<?>)cl);
                        } else {
                            processedClasses.add((Class)cl);
                        }
                    });
                } else {
                    Class<?> fieldType = field.getType();
                    if (!processedClasses.contains(fieldType)) {
                        if (this.reflectionService.isClassInSourceDirectory(fieldType)) {
                            classesToProcess.add(fieldType);
                        } else {
                            processedClasses.add(fieldType);
                        }
                    }
                }
            });
        }
        return entityClasses;
    }

    List<DomainObject> scanClasses(Collection<Class<?>> classes) {
        Set allEntityFullyQualifiedNames = classes.stream().map(Class::getName).collect(Collectors.toSet());
        return classes.stream().map(type -> this.toEntity((Class<?>)type, allEntityFullyQualifiedNames)).limit(100L).collect(Collectors.toList());
    }

    private DomainObject toEntity(Class<?> type, Set<String> allEntityFullyQualifiedNames) {
        DomainObject entity = new DomainObject();
        entity.name = type.getSimpleName();
        entity.fullyQualifiedName = type.getName();
        entity.aggregateRoot = this.isAggregateRoot(type);
        List fieldDescriptors = Arrays.stream(type.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(this::toFieldDescriptor).collect(Collectors.toList());
        entity.fields = fieldDescriptors.stream().map(FieldDescriptor::getField).collect(Collectors.toList());
        ArrayList dependencies = new ArrayList(entity.fields.stream().map(f -> f.typeFullyQualifiedName).filter(allEntityFullyQualifiedNames::contains).collect(Collectors.toList()));
        dependencies.addAll(fieldDescriptors.stream().flatMap(fd -> fd.getParameterClasses().stream()).map(Class::getName).filter(allEntityFullyQualifiedNames::contains).collect(Collectors.toList()));
        this.getBaseClass(type).ifPresent(baseClass -> {
            String baseClassFQN = baseClass.getName();
            if (allEntityFullyQualifiedNames.contains(baseClassFQN)) {
                dependencies.add(baseClassFQN);
                entity.baseTypeNames = Collections.singletonList(baseClass.getSimpleName());
            }
        });
        this.getImplementedInterfaces(type).forEach(interfaceClass -> {
            String interfaceClassFQN = interfaceClass.getName();
            if (allEntityFullyQualifiedNames.contains(interfaceClassFQN)) {
                dependencies.add(interfaceClassFQN);
                if (entity.implementationTypeNames == null) {
                    entity.implementationTypeNames = new ArrayList();
                }
                entity.implementationTypeNames.add(interfaceClass.getSimpleName());
            }
        });
        entity.dependsOnEntityFullyQualifiedNames = dependencies;
        entity.softDependsOnEntities = this.getSoftLinks(type);
        return entity;
    }

    private List<SoftLink> getSoftLinks(Class<?> type) {
        ArrayList softLinkAnnotations = new ArrayList();
        Arrays.stream(type.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> this.reflectionService.getAnnotation((java.lang.reflect.Field)field, ContextSoftLink.class.getName())).filter(Optional::isPresent).map(Optional::get).forEach(softLinkAnnotations::add);
        Arrays.stream(type.getMethods()).map(method -> this.reflectionService.getAnnotation((Method)method, ContextSoftLink.class.getName())).filter(Optional::isPresent).map(Optional::get).forEach(softLinkAnnotations::add);
        ArrayList<SoftLink> softLinks = new ArrayList<SoftLink>();
        for (Annotation softLinkAnnotation : softLinkAnnotations) {
            Optional<Object> entity = this.reflectionService.getAnnotationFieldValue(softLinkAnnotation, "entity");
            if (entity.isPresent() && !Void.TYPE.equals(entity.get())) {
                SoftLink softLink = new SoftLink();
                softLink.entityName = ((Class)entity.get()).getName();
                softLinks.add(softLink);
                continue;
            }
            Optional<Object> entityName = this.reflectionService.getAnnotationFieldValue(softLinkAnnotation, "entityName");
            Optional<Object> component = this.reflectionService.getAnnotationFieldValue(softLinkAnnotation, "component");
            if (!entityName.isPresent() || !component.isPresent()) continue;
            String entityNameString = (String)entityName.get();
            String componentString = (String)component.get();
            if (entityNameString == null || entityNameString.isEmpty() || componentString == null || componentString.isEmpty()) continue;
            SoftLink softLink = new SoftLink();
            softLink.entityName = entityNameString;
            softLink.componentName = componentString;
            softLinks.add(softLink);
        }
        return softLinks;
    }

    private boolean isAggregateRoot(Class<?> type) {
        Annotation[] annotations;
        for (Annotation ann : annotations = type.getAnnotations()) {
            String annotationFullyQualifiedName = ann.annotationType().getName();
            if (!classesSeenAsAggregateRoot.contains(annotationFullyQualifiedName)) continue;
            MojoLogger.logger.info("Found aggregate root " + type.getName());
            return true;
        }
        return false;
    }

    private List<Class<?>> getImplementedInterfaces(Class<?> type) {
        return Arrays.asList(type.getInterfaces());
    }

    private Optional<Class<?>> getBaseClass(Class<?> type) {
        Type baseType = type.getGenericSuperclass();
        if (baseType instanceof Class) {
            return Optional.of((Class)baseType);
        }
        if (baseType instanceof ParameterizedType && ((ParameterizedType)baseType).getRawType() instanceof Class) {
            return Optional.of((Class)((ParameterizedType)baseType).getRawType());
        }
        return Optional.empty();
    }

    private FieldDescriptor toFieldDescriptor(java.lang.reflect.Field f) {
        if (f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)f.getGenericType();
            Type[] parameterTypes = parameterizedType.getActualTypeArguments();
            ArrayList<Class<?>> parameterClasses = new ArrayList();
            if (parameterTypes != null) {
                parameterClasses = Arrays.stream(parameterTypes).filter(pt -> pt instanceof Class).map(pt -> (Class)pt).collect(Collectors.toList());
            }
            String parameterDescription = "<" + parameterClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(",")) + ">";
            Field field = new Field(f.getName(), f.getType().getSimpleName() + parameterDescription, f.getType().getName());
            return new FieldDescriptor(field, parameterClasses);
        }
        Field field = new Field(f.getName(), f.getType().getSimpleName(), f.getType().getName());
        return new FieldDescriptor(field);
    }

    private static class FieldDescriptor {
        private final Field field;
        private final List<Class<?>> parameterClasses;

        public FieldDescriptor(Field field) {
            this(field, Collections.emptyList());
        }

        public FieldDescriptor(Field field, List<Class<?>> parameterClasses) {
            this.field = field;
            this.parameterClasses = parameterClasses;
        }

        public Field getField() {
            return this.field;
        }

        public List<Class<?>> getParameterClasses() {
            return this.parameterClasses;
        }
    }
}

