/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.annotations.ContextExemplar;
import io.contextmap.application.ReflectionService;
import io.contextmap.application.VersionControlService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.Exemplar;
import io.contextmap.model.VersionControlledRemoteLocation;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;

public class ExemplarService {
    private final ReflectionService reflectionService;
    private final VersionControlService versionControlService;

    public ExemplarService(ReflectionService reflectionService, VersionControlService versionControlService) {
        this.reflectionService = reflectionService;
        this.versionControlService = versionControlService;
    }

    public List<Exemplar> scan(MavenProject mavenProject) {
        try {
            String[] classesUsedByExemplars = new String[]{ContextExemplar.class.getName()};
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedByExemplars);
            return this.scanClasses(classes, mavenProject);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for exemplars");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private List<Exemplar> scanClasses(Collection<Class<?>> classes, MavenProject mavenProject) {
        return classes.stream().map(type -> this.toExemplar((Class<?>)type, mavenProject)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<File> findSourceInFolder(Class<?> type, File folder) {
        if (!folder.exists()) {
            return Optional.empty();
        }
        File bestMatch = null;
        String className = type.getSimpleName();
        for (File file : folder.listFiles()) {
            if (!file.isFile()) continue;
            String filename = file.getName();
            if (filename.contains(".")) {
                filename = filename.substring(0, filename.indexOf(46));
            }
            if (className.equals(filename)) {
                return Optional.of(file);
            }
            if (!filename.contains(className) || bestMatch != null && bestMatch.getName().length() <= file.getName().length()) continue;
            bestMatch = file;
        }
        return Optional.ofNullable(bestMatch);
    }

    private File resolvePotentialRelativePathAsFile(File currentDir, String dir) {
        if (dir.contains(currentDir.getAbsolutePath())) {
            return new File(dir);
        }
        return new File(currentDir, dir);
    }

    private Optional<VersionControlledRemoteLocation> getRemoteLocationForClass(Class<?> type, MavenProject project) {
        String remoteOriginUrl;
        String packageFQN = type.getPackage().getName();
        File currentDir = project.getBasedir();
        String srcDir = project.getBuild().getSourceDirectory();
        String testDir = project.getBuild().getTestSourceDirectory();
        String pathToPackage = packageFQN.replace('.', '/');
        File packageInSrcDir = new File(this.resolvePotentialRelativePathAsFile(currentDir, srcDir), pathToPackage);
        File sourceFile = this.findSourceInFolder(type, packageInSrcDir).orElse(null);
        if (sourceFile == null) {
            File packageInTestDir = new File(this.resolvePotentialRelativePathAsFile(currentDir, testDir), pathToPackage);
            sourceFile = this.findSourceInFolder(type, packageInTestDir).orElse(null);
        }
        String relativePathToSourceFile = null;
        if (sourceFile != null) {
            Path first = currentDir.toPath();
            Path second = sourceFile.toPath();
            Path relativePathBetweenTwo = first.relativize(second);
            relativePathToSourceFile = relativePathBetweenTwo.toString();
        }
        if ((remoteOriginUrl = (String)this.versionControlService.getRemoteOriginUrl().orElse(null)) == null) {
            return Optional.empty();
        }
        String relativePathToVersionRoot = this.versionControlService.getRelativePathToVersionRoot(currentDir).orElse(null);
        String branch = this.versionControlService.getBranch().orElse(null);
        VersionControlledRemoteLocation remoteLocation = new VersionControlledRemoteLocation();
        remoteLocation.branch = branch;
        remoteLocation.relativePathToFile = relativePathToSourceFile;
        remoteLocation.remoteOriginUrl = remoteOriginUrl;
        remoteLocation.relativePathToVersionRoot = relativePathToVersionRoot;
        return Optional.of(remoteLocation);
    }

    private Optional<Exemplar> toExemplar(Class<?> type, MavenProject mavenProject) {
        Exemplar exemplar = new Exemplar();
        this.reflectionService.getAnnotation(type, ContextExemplar.class.getName()).ifPresent(annotation -> {
            ContextExemplar contextExemplar = (ContextExemplar)annotation;
            exemplar.title = contextExemplar.title();
            exemplar.description = contextExemplar.description();
            exemplar.tags = Arrays.asList(contextExemplar.tags());
            exemplar.remoteLocation = this.getRemoteLocationForClass(type, mavenProject).orElse(null);
        });
        if (exemplar.title == null || exemplar.title.isEmpty()) {
            return Optional.empty();
        }
        if (exemplar.remoteLocation == null) {
            return Optional.empty();
        }
        return Optional.of(exemplar);
    }
}

