/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application.endpoints;

import io.contextmap.annotations.rest.ContextRestEndpoint;
import io.contextmap.application.ReflectionService;
import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import io.contextmap.model.SecurityRolePermission;
import io.contextmap.model.json.NodeType;
import io.contextmap.model.json.ScannedJsonNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EndpointReflection {
    private final ReflectionService reflectionService;

    public EndpointReflection(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public String getPathOrValueFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "path");
        if (!result.isPresent() || ((Object[])result.get()).length == 0) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        }
        if (result.isPresent() && ((Object[])result.get()).length > 0) {
            CharSequence[] paths = (String[])result.get();
            return String.join((CharSequence)"", paths);
        }
        return "";
    }

    public List<RestApiEndpoint> getEndpoints(Class<?> type, String pathPrefix) {
        List classLevelAnnotations = Arrays.stream(type.getAnnotations()).collect(Collectors.toList());
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(type.getMethods()));
        methods.addAll(Arrays.asList(type.getDeclaredMethods()));
        return methods.stream().map(method -> this.checkMethodForEndpoint((Method)method, pathPrefix, classLevelAnnotations)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RestApiEndpoint> checkMethodForEndpoint(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        Optional<RestApiEndpoint> endpoint = this.checkMethodAsGET(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        endpoint = this.checkMethodAsPOST(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        endpoint = this.checkMethodAsPUT(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        endpoint = this.checkMethodAsDELETE(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        endpoint = this.checkMethodAsPATCH(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        endpoint = this.checkMethodAsREQUEST(method, pathPrefix, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        return Optional.empty();
    }

    private Optional<RestApiEndpoint> checkMethodAsPOST(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String postMapping = "org.springframework.web.bind.annotation.PostMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, postMapping, annotation -> "POST", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String postExchange = "org.springframework.web.service.annotation.PostExchange";
        return this.checkFor(method, pathPrefix, postExchange, annotation -> "POST", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkMethodAsPUT(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String putMapping = "org.springframework.web.bind.annotation.PutMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, putMapping, annotation -> "PUT", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String putExchange = "org.springframework.web.service.annotation.PutExchange";
        return this.checkFor(method, pathPrefix, putExchange, annotation -> "PUT", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkMethodAsPATCH(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String patchMapping = "org.springframework.web.bind.annotation.PatchMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, patchMapping, annotation -> "PATCH", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String patchExchange = "org.springframework.web.service.annotation.PatchExchange";
        return this.checkFor(method, pathPrefix, patchExchange, annotation -> "PATCH", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkMethodAsDELETE(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String deleteMapping = "org.springframework.web.bind.annotation.DeleteMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, deleteMapping, annotation -> "DELETE", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String deleteExchange = "org.springframework.web.service.annotation.DeleteExchange";
        return this.checkFor(method, pathPrefix, deleteExchange, annotation -> "DELETE", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkMethodAsREQUEST(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String requestMapping = "org.springframework.web.bind.annotation.RequestMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, requestMapping, this::getRequestMethodFromAnnotation, this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String httpExchange = "org.springframework.web.service.annotation.HttpExchange";
        return this.checkFor(method, pathPrefix, httpExchange, this::getRequestMethodFromHttpExchange, this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkMethodAsGET(Method method, String pathPrefix, List<Annotation> classLevelAnnotations) {
        String getMapping = "org.springframework.web.bind.annotation.GetMapping";
        Optional<RestApiEndpoint> endpoint = this.checkFor(method, pathPrefix, getMapping, annotation -> "GET", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        String getExchange = "org.springframework.web.service.annotation.GetExchange";
        return this.checkFor(method, pathPrefix, getExchange, annotation -> "GET", this::getProducesFromAnnotation, this::getConsumesFromAnnotation, classLevelAnnotations);
    }

    private Optional<RestApiEndpoint> checkFor(Method method, String pathPrefix, String mappingFQN, Function<Annotation, String> requestMethodParser, Function<Annotation, Optional<String>> producesParser, Function<Annotation, Optional<String>> consumesParser, List<Annotation> classLevelAnnotations) {
        Annotation annotation = this.reflectionService.getAnnotation(method, mappingFQN).orElse(null);
        if (annotation == null) {
            return Optional.empty();
        }
        String path = mappingFQN.endsWith("Exchange") ? this.getUrlOrValueFromExchangeAnnotation(annotation) : this.getPathOrValueFromAnnotation(annotation);
        RestApiEndpoint endpoint = new RestApiEndpoint();
        endpoint.requestMethod = requestMethodParser.apply(annotation);
        endpoint.path = pathPrefix + path;
        endpoint.requestParameters = this.getRequestParameters(method);
        if (endpoint.path.isEmpty()) {
            MojoLogger.logger.warn("Bumped into an empty path for endpoint defined by method: " + method.getName());
        }
        endpoint.securityRoleOrPermissions = this.getSecurityRolePermissions(method);
        if (endpoint.securityRoleOrPermissions.isEmpty()) {
            endpoint.securityRoleOrPermissions = this.getSecurityRolePermissions(classLevelAnnotations);
        }
        endpoint.description = this.getEndpointDescription(method);
        endpoint.deprecated = this.getEndpointDeprecated(method);
        Optional<String> produces = producesParser.apply(annotation);
        endpoint.responseHeaders = produces.isPresent() ? Collections.singletonList(new RestApiEndpoint.Header("Content-Type", produces.get())) : Collections.emptyList();
        endpoint.responseBodyJsonNode = this.getResponseBody(method);
        if (endpoint.responseBodyJsonNode != null && endpoint.responseBodyJsonNode.getNodeType() == NodeType.VALUE_NULL) {
            endpoint.responseBodyJsonNode = null;
        }
        endpoint.requestBodyJsonNode = this.getRequestBody(method);
        endpoint.requestHeaders = new ArrayList();
        consumesParser.apply(annotation).ifPresent(consumes -> endpoint.requestHeaders.add(new RestApiEndpoint.Header("Content-Type", consumes)));
        endpoint.requestHeaders.addAll(this.getRequestHeaderParameters(method));
        return Optional.of(endpoint);
    }

    private List<RestApiEndpoint.Header> getRequestHeaderParameters(Method method) {
        String requestHeaderAnnotationFQN = "org.springframework.web.bind.annotation.RequestHeader";
        Map<Parameter, Annotation> requestHeadersMap = this.reflectionService.getArgumentsWithAnnotation(method, requestHeaderAnnotationFQN);
        return requestHeadersMap.values().stream().map(this::getValueOrNameFromAnnotation).filter(valueOrName -> valueOrName != null && !valueOrName.isEmpty()).map(valueOrName -> new RestApiEndpoint.Header(valueOrName, "")).collect(Collectors.toList());
    }

    private String getRequestMethodFromHttpExchange(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "method");
        if (!result.isPresent()) {
            return "GET";
        }
        String method = (String)result.get();
        if (method.isEmpty()) {
            return "GET";
        }
        String clean = method.toUpperCase(Locale.US);
        if ("GET".equals(clean) || "POST".equals(clean) || "PATCH".equals(clean) || "PUT".equals(clean) || "DELETE".equals(clean)) {
            return method;
        }
        return "GET";
    }

    private String getRequestMethodFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "method");
        if (result.isPresent() && ((Object[])result.get()).length > 0) {
            Object[] methodValues = (Object[])result.get();
            return String.valueOf(methodValues[0]);
        }
        MojoLogger.logger.warn("Could not find request method, falling back to GET");
        return "GET";
    }

    private Optional<String> getProducesFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "produces");
        if (result.isPresent() && ((Object[])result.get()).length > 0) {
            CharSequence[] values = (String[])result.get();
            return Optional.of(String.join((CharSequence)", ", values));
        }
        return Optional.empty();
    }

    private Optional<String> getConsumesFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "consumes");
        if (result.isPresent() && ((Object[])result.get()).length > 0) {
            CharSequence[] values = (String[])result.get();
            return Optional.of(String.join((CharSequence)", ", values));
        }
        return Optional.empty();
    }

    private String replacePathParameters(String path) {
        if (path == null) {
            return path;
        }
        return path.replaceAll("(?<=\\{).*?(?=\\})", "");
    }

    private List<SecurityRolePermission> getSecurityRolePermissions(List<Annotation> annotations) {
        String securedAnnotationFQN = "org.springframework.security.access.annotation.Secured";
        return annotations.stream().filter(a -> a.annotationType().getName().equals(securedAnnotationFQN)).map(this::getSecurityRolePermissionFromAnnotation).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean getEndpointDeprecated(Method method) {
        boolean deprecated = this.reflectionService.getAnnotation(method, "io.swagger.v3.oas.annotations.Operation").map(annotation -> (Boolean)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "deprecated").orElse(false)).orElse(false);
        if (deprecated) {
            return deprecated;
        }
        deprecated = this.reflectionService.getAnnotation(method, "java.lang.Deprecated").isPresent();
        return deprecated;
    }

    private String getEndpointDescription(Method method) {
        String description = this.reflectionService.getAnnotation(method, ContextRestEndpoint.class.getName()).map(annotation -> (String)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "description").orElse("")).orElse("");
        if (!description.isEmpty()) {
            return description;
        }
        description = this.reflectionService.getAnnotation(method, "io.swagger.v3.oas.annotations.Operation").map(annotation -> (String)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "description").orElse("")).orElse("");
        if (!description.isEmpty()) {
            return description;
        }
        description = this.reflectionService.getAnnotation(method, "io.swagger.v3.oas.annotations.Operation").map(annotation -> (String)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "summary").orElse("")).orElse("");
        if (!description.isEmpty()) {
            return description;
        }
        description = this.reflectionService.getAnnotation(method, "io.swagger.annotations.ApiOperation").map(annotation -> (String)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "notes").orElse("")).orElse("");
        if (!description.isEmpty()) {
            return description;
        }
        description = this.reflectionService.getAnnotation(method, "io.swagger.annotations.ApiOperation").map(annotation -> (String)this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value").orElse("")).orElse("");
        return description;
    }

    private List<SecurityRolePermission> getSecurityRolePermissions(Method method) {
        String securedAnnotationFQN = "org.springframework.security.access.annotation.Secured";
        return this.reflectionService.getAnnotation(method, securedAnnotationFQN).map(this::getSecurityRolePermissionFromAnnotation).orElse(Collections.emptyList());
    }

    private List<SecurityRolePermission> getSecurityRolePermissionFromAnnotation(Annotation securedAnnotation) {
        if (securedAnnotation == null) {
            return Collections.emptyList();
        }
        return this.getValuesFromAnnotation(securedAnnotation).stream().map(role -> {
            SecurityRolePermission srp = new SecurityRolePermission();
            srp.key = "Role";
            srp.value = role;
            return srp;
        }).collect(Collectors.toList());
    }

    private List<RestApiEndpoint.RequestParameter> getRequestParameters(Method method) {
        String requestParamAnnotationFQN = "org.springframework.web.bind.annotation.RequestParam";
        Map<Parameter, Annotation> requestParams = this.reflectionService.getArgumentsWithAnnotation(method, requestParamAnnotationFQN);
        ArrayList<RestApiEndpoint.RequestParameter> requestParameters = new ArrayList<RestApiEndpoint.RequestParameter>();
        requestParams.forEach((parameter, annotation) -> {
            RestApiEndpoint.RequestParameter requestParameter = new RestApiEndpoint.RequestParameter();
            requestParameter.optional = !this.getRequiredFromAnnotation((Annotation)annotation);
            String nameFromAnnotation = this.getValueOrNameFromAnnotation((Annotation)annotation);
            requestParameter.name = nameFromAnnotation.isEmpty() ? parameter.getName() : nameFromAnnotation;
            requestParameters.add(requestParameter);
        });
        return requestParameters;
    }

    private ScannedJsonNode getRequestBody(Method method) {
        String requestBodyAnnotationFQN = "org.springframework.web.bind.annotation.RequestBody";
        Map<Parameter, Annotation> requestBodyMap = this.reflectionService.getArgumentsWithAnnotation(method, requestBodyAnnotationFQN);
        if (requestBodyMap.isEmpty()) {
            return null;
        }
        Parameter requestBodyParameter = requestBodyMap.keySet().iterator().next();
        Class<?> requestBodyType = requestBodyParameter.getType();
        Property property = new Property("", method, method, null, requestBodyType);
        List typesToExcludeToPreventLoop = Collections.emptyList();
        return new ObjectToJsonConverter((ObjectToJsonConverter.ObjectToJsonReflection)this.reflectionService, (ObjectToJsonConverter.ObjectToJsonLogger)MojoLogger.logger).deserializedJson(requestBodyType, property, typesToExcludeToPreventLoop);
    }

    private ScannedJsonNode getResponseBody(Method method) {
        Class<?> returnType = method.getReturnType();
        Property property = new Property("", method, null, null, returnType);
        List typesToExcludeToPreventLoop = Collections.emptyList();
        return new ObjectToJsonConverter((ObjectToJsonConverter.ObjectToJsonReflection)this.reflectionService, (ObjectToJsonConverter.ObjectToJsonLogger)MojoLogger.logger).serializedJson(returnType, property, typesToExcludeToPreventLoop);
    }

    private List<String> getValuesFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        if (result.isPresent() && ((Object[])result.get()).length > 0) {
            String[] paths = (String[])result.get();
            return Arrays.asList(paths);
        }
        return Collections.emptyList();
    }

    private boolean getRequiredFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "required");
        if (result.isPresent()) {
            return (Boolean)result.get();
        }
        return true;
    }

    private String getValueOrNameFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "name");
        }
        return result.map(value -> (String)value).orElse("");
    }

    private String getUrlOrValueFromExchangeAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "url");
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        }
        return result.map(value -> {
            try {
                return (String)value;
            }
            catch (ClassCastException e) {
                return "";
            }
        }).orElse("");
    }
}

