/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.rabbitmq;

import io.contextmap.annotations.ContextEvent;
import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.core.reflection.ReflectionFunctions;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.data.util.AnnotatedTypeScanner;

public class RabbitMQScanner
extends AbstractRuntimeScanner {
    private static Logger logger = LoggerFactory.getLogger(RabbitMQScanner.class);
    private final ScanApplicationContext context;

    public RabbitMQScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, String> subscribedExchanges = this.getSubscribedExchanges();
        Set<Event> publishedEvents = this.getPublishedExchanges(subscribedExchanges);
        data.setPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
        Set<Event> subscribedEvents = subscribedExchanges.keySet().stream().map(Event::new).collect(Collectors.toSet());
        data.setSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
    }

    private Map<String, String> getSubscribedExchanges() {
        Map<String, ?> bindingBeans = this.context.getBeansOfType("org.springframework.amqp.core.Binding");
        if (bindingBeans.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> subscribedExchanges = new HashMap<String, String>();
        bindingBeans.values().stream().forEach(b -> {
            Binding binding = (Binding)b;
            String exchangeName = binding.getExchange();
            String virtualHostName = this.getVirtualHost((Declarable)binding);
            subscribedExchanges.put(this.formatName(virtualHostName, exchangeName), binding.getDestination());
        });
        return subscribedExchanges;
    }

    private Set<Event> getPublishedExchanges(Map<String, String> subscribedExchanges) {
        HashSet<String> publishedExchanges = new HashSet<String>();
        publishedExchanges.addAll(this.getPublishedExchangesFromExchanges(subscribedExchanges));
        publishedExchanges.addAll(this.getPublishedExchangesFromRabbitTemplates(subscribedExchanges));
        Map<String, Event> publishedEvents = publishedExchanges.stream().map(Event::new).collect(Collectors.toMap(Event::getName, e -> e));
        AnnotatedTypeScanner contextEventScanner = new AnnotatedTypeScanner(new Class[]{ContextEvent.class});
        Set typesAnnotatedWithContextEvent = contextEventScanner.findTypes(this.context.getComponentScanPackages());
        HashMap<Class, Set> eventClassToPublishers = new HashMap<Class, Set>();
        for (Class eventClass2 : typesAnnotatedWithContextEvent) {
            Optional<Object> publishedByOptional;
            Optional<Annotation> annotation = this.getAnnotation(eventClass2, ContextEvent.class.getName());
            if (!annotation.isPresent() || !(publishedByOptional = this.getAnnotationFieldValue(annotation.get(), "publishedBy")).isPresent()) continue;
            HashSet publishedByExchangeNames = new HashSet();
            eventClassToPublishers.put(eventClass2, publishedByExchangeNames);
            String[] publishedBy = (String[])publishedByOptional.get();
            Arrays.stream(publishedBy).filter(Objects::nonNull).forEach(beanName -> {
                Optional<Object> optionalBean = this.context.getBeanByName((String)beanName);
                if (optionalBean.isPresent()) {
                    Object bean = optionalBean.get();
                    String publishedByExchangeName = null;
                    if (bean instanceof Exchange) {
                        publishedByExchangeName = this.getNameOfExchange((Exchange)bean);
                    } else if (bean instanceof RabbitTemplate) {
                        publishedByExchangeName = this.getNameOfExchange((RabbitTemplate)bean);
                    } else {
                        logger.error("Unable to extract exchange name of ContextEvent {} since the bean is not a RabbitTemplateor Exchange, but it's of type {}", (Object)eventClass2, bean.getClass());
                    }
                    if (publishedByExchangeName != null && !publishedByExchangeName.isEmpty()) {
                        publishedByExchangeNames.add(publishedByExchangeName);
                    }
                }
            });
        }
        eventClassToPublishers.forEach((eventClass, exchangeNames) -> {
            Property property = new Property("", null, null, null, eventClass);
            List typesToExcludeToPreventLoop = Collections.emptyList();
            ObjectToJsonConverter.ObjectToJsonReflection objectToJsonReflection = new ObjectToJsonConverter.ObjectToJsonReflection(){

                public Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
                    return ReflectionFunctions.getAnnotationFieldValue((Annotation)annotation, (String)fieldName);
                }

                public Optional<Annotation> getAnnotation(Method method, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Method)method, (String)annotationFullyQualifiedName);
                }

                public Optional<Annotation> getAnnotation(Field field, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Field)field, (String)annotationFullyQualifiedName);
                }
            };
            ObjectToJsonConverter.ObjectToJsonLogger objectToJsonLogger = new ObjectToJsonConverter.ObjectToJsonLogger(){

                public void debug(CharSequence message) {
                    logger.debug(message.toString());
                }

                public void info(CharSequence message) {
                    logger.info(message.toString());
                }

                public void warn(CharSequence message) {
                    logger.warn(message.toString());
                }
            };
            ObjectToJsonConverter converter = new ObjectToJsonConverter(objectToJsonReflection, objectToJsonLogger);
            String resulingJson = converter.serializedJson(eventClass, property, typesToExcludeToPreventLoop);
            exchangeNames.forEach(exchangeName -> {
                Event eventForExchange = (Event)publishedEvents.get(exchangeName);
                if (eventForExchange != null) {
                    eventForExchange.getPayloads().add(resulingJson);
                } else {
                    Event missingEvent = new Event((String)exchangeName);
                    missingEvent.getPayloads().add(resulingJson);
                    publishedEvents.put((String)exchangeName, missingEvent);
                }
            });
        });
        return new HashSet<Event>(publishedEvents.values());
    }

    private Set<String> getPublishedExchangesFromExchanges(Map<String, String> subscribedExchanges) {
        Map<String, ?> exchangeBeans = this.context.getBeansOfType("org.springframework.amqp.core.Exchange");
        if (exchangeBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> publishedExchanges = new HashSet<String>();
        exchangeBeans.values().forEach(ex -> {
            Exchange exchange = (Exchange)ex;
            String exchangeName = exchange.getName();
            String fullname = this.getNameOfExchange(exchange);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                publishedExchanges.add(fullname);
            }
        });
        return publishedExchanges;
    }

    private String getNameOfExchange(Exchange exchange) {
        String exchangeName = exchange.getName();
        String virtualHostName = this.getVirtualHost((Declarable)exchange);
        return this.formatName(virtualHostName, exchangeName);
    }

    private String getNameOfExchange(RabbitTemplate rabbitTemplate) {
        String exchangeName = rabbitTemplate.getExchange();
        String virtualHostName = this.getVirtualHost(rabbitTemplate);
        return this.formatName(virtualHostName, exchangeName);
    }

    private Set<String> getPublishedExchangesFromRabbitTemplates(Map<String, String> subscribedExchanges) {
        Map<String, ?> rabbiteTemplateBeans = this.context.getBeansOfType("org.springframework.amqp.rabbit.core.RabbitTemplate");
        if (rabbiteTemplateBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> publishedExchanges = new HashSet<String>();
        rabbiteTemplateBeans.values().forEach(tmpl -> {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)tmpl;
            String exchangeName = rabbitTemplate.getExchange();
            String fullname = this.getNameOfExchange(rabbitTemplate);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                publishedExchanges.add(fullname);
            }
        });
        return publishedExchanges;
    }

    private String getVirtualHost(Declarable declarable) {
        Object admin;
        if (declarable.getDeclaringAdmins() != null && !declarable.getDeclaringAdmins().isEmpty() && (admin = declarable.getDeclaringAdmins().iterator().next()) instanceof RabbitAdmin) {
            return this.getVirtualHost(((RabbitAdmin)admin).getRabbitTemplate());
        }
        return "";
    }

    private String getVirtualHost(RabbitTemplate rabbitTemplate) {
        return rabbitTemplate.getConnectionFactory().getVirtualHost();
    }

    private String formatName(String virtualHost, String exchangeOrQueue) {
        if (virtualHost == null || virtualHost.trim().isEmpty()) {
            return "/:" + exchangeOrQueue;
        }
        return virtualHost + ":" + exchangeOrQueue;
    }

    private Optional<Annotation> getAnnotation(Class<?> type, String annotationFullyQualifiedName) {
        return Arrays.stream(type.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst();
    }

    public Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        return Arrays.stream(methods).filter(f -> fieldName.equals(f.getName())).findFirst().map(f -> {
            try {
                return f.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to get value of annotation " + annotation.annotationType());
                return null;
            }
        });
    }
}

