/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.http;

import java.util.Base64;

public class Parameters {
    private String clearTextText;
    private boolean scanningEnabled;
    private boolean dryRun;
    private String multiModuleComponentName;
    private String defaultStorageSchema;

    public boolean isKeyAvailable() {
        return this.clearTextText != null && !this.clearTextText.isEmpty();
    }

    public void setKey(String key) {
        String keyString;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Missing required key configuration parameter");
        }
        try {
            byte[] data = Base64.getDecoder().decode(key.trim());
            keyString = new String(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid key configuration parameter");
        }
        int colonIndex = keyString.indexOf(58);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Invalid key configuration parameter");
        }
        this.clearTextText = keyString;
    }

    public String getUsername() {
        int colonIndex = this.clearTextText.indexOf(58);
        return this.clearTextText.substring(0, colonIndex);
    }

    public String getPassword() {
        int colonIndex = this.clearTextText.indexOf(58);
        return this.clearTextText.substring(colonIndex + 1);
    }

    public boolean isScanningEnabled() {
        return this.scanningEnabled;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setScanningEnabled(boolean scanningEnabled) {
        this.scanningEnabled = scanningEnabled;
    }

    public String getMultiModuleComponentName() {
        return this.multiModuleComponentName;
    }

    public void setMultiModuleComponentName(String multiModuleComponentName) {
        this.multiModuleComponentName = multiModuleComponentName;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public String getDefaultStorageSchema() {
        return this.defaultStorageSchema;
    }

    public void setDefaultStorageSchema(String defaultStorageSchema) {
        this.defaultStorageSchema = defaultStorageSchema;
    }
}

