/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.model;

import io.contextmap.spring.runtime.http.Parameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class ScanApplicationContext {
    private final ApplicationContext applicationContext;
    private final Parameters parameters;
    private final String appName;

    public ScanApplicationContext(ApplicationContext applicationContext, Parameters parameters, String appName) {
        this.applicationContext = applicationContext;
        this.appName = appName;
        this.parameters = parameters;
    }

    public String getApplicationId() {
        return this.appName;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Optional<Object> getBeanByName(String beanName) {
        try {
            return Optional.ofNullable(this.applicationContext.getBean(beanName));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Map<String, ?> getBeansOfType(String fullyQualifiedName) {
        try {
            Class<?> type = this.getClass(fullyQualifiedName);
            return this.applicationContext.getBeansOfType(type);
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyMap();
        }
    }

    public Set<String> getComponentScanPackages() {
        HashSet<String> componentScanPackages = new HashSet<String>();
        this.applicationContext.getBeansWithAnnotation(ComponentScan.class).forEach((name, instance) -> {
            HashSet<String> packagesFromBean = new HashSet<String>();
            Set scans = AnnotatedElementUtils.getMergedRepeatableAnnotations(instance.getClass(), ComponentScan.class);
            for (ComponentScan scan : scans) {
                Arrays.stream(scan.basePackageClasses()).forEach(cl -> packagesFromBean.add(cl.getPackage().getName()));
                Arrays.stream(scan.basePackages()).forEach(packagesFromBean::add);
            }
            if (packagesFromBean.isEmpty()) {
                packagesFromBean.add(instance.getClass().getPackage().getName());
            }
            componentScanPackages.addAll(packagesFromBean);
        });
        return componentScanPackages;
    }

    private Class<?> getClass(String fullyQualifiedName) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(fullyQualifiedName);
    }
}

