/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime;

import io.contextmap.spring.runtime.http.SendClient;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.ScanExecution;
import io.contextmap.spring.runtime.model.ScannedComponent;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.NameScanner;
import io.contextmap.spring.runtime.scanner.events.jms.ActiveMQJmsScanner;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.RabbitMQScanner;
import io.contextmap.spring.runtime.scanner.storage.cache.CacheStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.elastic.ElasticStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.jdbc.JdbcStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.mongodb.MongoStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.solr.SolrStorageScanner;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class ScanAtStartup
implements ApplicationListener<ApplicationReadyEvent> {
    private static Logger logger = LoggerFactory.getLogger(ScanAtStartup.class);
    private final ScanApplicationContext applicationContext;
    private final List<AbstractRuntimeScanner> scanners;

    public ScanAtStartup(ScanApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.scanners = this.createScanners();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.applicationContext.getParameters().isScanningEnabled()) {
            logger.info("ContextMap runtime scan is not enabled. To enable configure property \"contextmap.enabled=true\"");
            return;
        }
        if (!this.applicationContext.getParameters().isKeyAvailable()) {
            return;
        }
        if (this.applicationContext.getApplicationId() == null || this.applicationContext.getApplicationId().isEmpty()) {
            logger.error("ContextMap is missing a required spring.application.name property");
            return;
        }
        this.startScanThread();
    }

    private void startScanThread() {
        try {
            Thread scanThread = new Thread(this::scan, "contextmap-scan");
            scanThread.start();
        }
        catch (Exception e) {
            logger.info("Error while scanning for metadata: " + e.getMessage());
        }
        finally {
            logger.debug("Finalized contextmap-scan thread");
        }
    }

    private void scan() {
        logger.info("ContextMap is scanning for metadata...");
        Scan data = new Scan();
        data.setPluginName("io.contextmap.spring-runtime");
        data.setPluginVersion("1.1.0");
        data.setExecution(new ScanExecution());
        data.setScannedComponent(new ScannedComponent());
        this.scanners.forEach(scanner -> scanner.scan(data));
        SendClient client = new SendClient(this.applicationContext);
        boolean success = client.send(data);
        if (success) {
            logger.info("ContextMap successfully scanned metadata");
        }
    }

    private List<AbstractRuntimeScanner> createScanners() {
        ArrayList<AbstractRuntimeScanner> scanners = new ArrayList<AbstractRuntimeScanner>();
        scanners.add(new NameScanner(this.applicationContext));
        scanners.add(new JdbcStorageScanner(this.applicationContext));
        scanners.add(new CacheStorageScanner(this.applicationContext));
        if (ScanAtStartup.isClassAvailable("org.springframework.amqp.core.Exchange")) {
            scanners.add(new RabbitMQScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.jms.core.JmsTemplate")) {
            scanners.add(new ActiveMQJmsScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.data.mongodb.core.MongoTemplate")) {
            scanners.add(new MongoStorageScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.elasticsearch.client.RestClient")) {
            scanners.add(new ElasticStorageScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.data.solr.core.SolrTemplate")) {
            scanners.add(new SolrStorageScanner(this.applicationContext));
        }
        scanners.forEach(s -> logger.debug("Created scanner: " + s.getClass().getSimpleName()));
        return scanners;
    }

    public static boolean isClassAvailable(String className) {
        try {
            return Class.forName(className, false, ScanAtStartup.class.getClassLoader()) != null;
        }
        catch (Exception e) {
            logger.debug("Class NOT available: " + className);
            return false;
        }
    }
}

