/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.azure.servicebus;

import com.azure.spring.messaging.servicebus.core.DefaultServiceBusNamespaceProducerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusTemplate;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;

public class AzureServiceBusCloudStreamScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(AzureServiceBusCloudStreamScanner.class);
    private final ScanApplicationContext context;

    public AzureServiceBusCloudStreamScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, ?> bindingServiceBeans = this.context.getBeansOfType("org.springframework.cloud.stream.binding.BindingService");
        if (bindingServiceBeans.isEmpty()) {
            return;
        }
        data.getExecution().setScannedPublishedEvents(true);
        data.getExecution().setScannedSubscribedEvents(true);
        for (Object bindingService : bindingServiceBeans.values()) {
            try {
                Set<Event> outputs = this.reflectOutputs((BindingService)bindingService);
                data.addPublishedEvents(outputs);
                Set<Event> inputs = this.reflectInputs((BindingService)bindingService);
                data.addSubscribedEvents(inputs);
            }
            catch (Throwable e) {
                logger.warn("Problem detected while scanning servicebus: {}", (Object)e.getMessage());
            }
        }
    }

    private Set<Event> reflectOutputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("producerBindings");
        field.setAccessible(true);
        Map producerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (Binding binding : producerBindings.values()) {
            try {
                String serviceBusName = binding.getName();
                String namespace = null;
                ServiceBusTemplate serviceBusTemplate = null;
                if (!(binding instanceof DefaultBinding)) continue;
                DefaultBinding defaultBinding = (DefaultBinding)binding;
                field = DefaultBinding.class.getDeclaredField("target");
                field.setAccessible(true);
                Object target = field.get(defaultBinding);
                if (target instanceof DirectChannel) {
                    AbstractDispatcher unicastingDispatcher;
                    DirectChannel channel = (DirectChannel)target;
                    field = DirectChannel.class.getDeclaredField("dispatcher");
                    field.setAccessible(true);
                    Object dispatcher = field.get(channel);
                    if (dispatcher instanceof AbstractDispatcher && (unicastingDispatcher = (AbstractDispatcher)dispatcher).getHandlerCount() > 0) {
                        field = AbstractDispatcher.class.getDeclaredField("handlers");
                        field.setAccessible(true);
                        Set handlers = (Set)field.get(unicastingDispatcher);
                        Object handler = handlers.iterator().next();
                        field = handler.getClass().getDeclaredField("delegate");
                        field.setAccessible(true);
                        Object delegate = field.get(handler);
                        if (delegate != null) {
                            Optional<NamespaceProperties> props;
                            field = delegate.getClass().getDeclaredField("sendOperation");
                            field.setAccessible(true);
                            Object sendOperation = field.get(delegate);
                            if (sendOperation instanceof ServiceBusTemplate && (props = this.getNameSpaceProperties(serviceBusTemplate = (ServiceBusTemplate)sendOperation)).isPresent()) {
                                namespace = props.get().getNamespace();
                            }
                        }
                    }
                }
                String fullName = this.formatName(namespace, serviceBusName);
                Event event = new Event(fullName, serviceBusName);
                events.add(event);
                HashMap<String, Event> eventWrappedInMap = new HashMap<String, Event>();
                eventWrappedInMap.put(event.getName(), event);
                eventWrappedInMap.put(serviceBusName, event);
                Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveNameFromPublishedByName);
                EventFunctions.addPayloadsToEvents(eventClassToPublishers, eventWrappedInMap);
                if (serviceBusTemplate == null) continue;
                this.addPropertiesToEventFromServiceBusTemplate(event, serviceBusTemplate, serviceBusName);
            }
            catch (Throwable t) {
                logger.warn("Problem detected while scanning servicebus: {}", (Object)t.getMessage());
            }
        }
        return events;
    }

    private void addPropertiesToEventFromServiceBusTemplate(Event event, ServiceBusTemplate serviceBusTemplate, String serviceBusName) throws Exception {
        event.addPropertyIfValueNotBlank("Message Broker", "Azure ServiceBus");
        event.addPropertyIfValueNotBlank("ServiceBus Name", serviceBusName);
        this.getNameSpaceProperties(serviceBusTemplate).ifPresent(props -> {
            event.addPropertyIfValueNotBlank("Namespace", props.getNamespace());
            event.addPropertyIfValueNotBlank("Type", props.getEntityType().name().toLowerCase(Locale.US));
        });
    }

    private Set<Event> reflectInputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("consumerBindings");
        field.setAccessible(true);
        Map consumerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (List bindings : consumerBindings.values()) {
            for (Binding binding : bindings) {
                try {
                    String serviceBusName = binding.getName();
                    String namespace = null;
                    if (!(binding instanceof DefaultBinding)) continue;
                    DefaultBinding defaultBinding = (DefaultBinding)binding;
                    field = DefaultBinding.class.getDeclaredField("lifecycle");
                    field.setAccessible(true);
                    Object lifecycle = field.get(defaultBinding);
                    if (lifecycle != null) {
                        field = lifecycle.getClass().getDeclaredField("listenerContainer");
                        field.setAccessible(true);
                        Object listenerContainer = field.get(lifecycle);
                        if (listenerContainer != null) {
                            field = listenerContainer.getClass().getDeclaredField("processorFactory");
                            field.setAccessible(true);
                            Object processorFactory = field.get(listenerContainer);
                            if (processorFactory != null) {
                                field = processorFactory.getClass().getDeclaredField("namespaceProperties");
                                field.setAccessible(true);
                                Object namespaceProperties = field.get(processorFactory);
                                if (namespaceProperties != null) {
                                    namespace = ((NamespaceProperties)namespaceProperties).getNamespace();
                                }
                            }
                        }
                    }
                    String fullName = this.formatName(namespace, serviceBusName);
                    Event event = new Event(fullName, serviceBusName);
                    events.add(event);
                }
                catch (Throwable t) {
                    logger.warn("Problem detected while scanning servicebus: {}", (Object)t.getMessage());
                }
            }
        }
        return events;
    }

    protected String formatName(String namespace, String serviceBusName) {
        return this.formatNamespace(namespace) + ":" + serviceBusName;
    }

    protected String formatNamespace(String namespace) {
        if (namespace == null || namespace.trim().isEmpty()) {
            String defaultNS = this.context.getParameters().getDefaultAzureServiceBusNamespace();
            if (defaultNS != null && !defaultNS.trim().isEmpty()) {
                return defaultNS;
            }
            return "/";
        }
        return namespace;
    }

    private Optional<NamespaceProperties> getNameSpaceProperties(ServiceBusTemplate serviceBusTemplate) throws Exception {
        Field field = ServiceBusTemplate.class.getDeclaredField("producerFactory");
        field.setAccessible(true);
        ServiceBusProducerFactory serviceBusProducerFactory = (ServiceBusProducerFactory)field.get(serviceBusTemplate);
        if (serviceBusProducerFactory instanceof DefaultServiceBusNamespaceProducerFactory) {
            DefaultServiceBusNamespaceProducerFactory d = (DefaultServiceBusNamespaceProducerFactory)serviceBusProducerFactory;
            field = DefaultServiceBusNamespaceProducerFactory.class.getDeclaredField("namespaceProperties");
            field.setAccessible(true);
            NamespaceProperties properties = (NamespaceProperties)field.get(d);
            return Optional.ofNullable(properties);
        }
        return Optional.empty();
    }

    protected String resolveNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        return this.context.resolveSpELStringValue(publishedByName);
    }
}

