/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.azure.eventhub;

import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureEventHubScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(AzureEventHubScanner.class);
    private final ScanApplicationContext context;

    public AzureEventHubScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        logger.info("Scanning Azure EventHub events");
        Set<String> subscribedEventHubs = this.getSubscribedEventHubs();
        Set<Event> publishedEvents = this.getPublishedEventHubs(subscribedEventHubs);
        data.addPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
        Set<Event> subscribedEvents = subscribedEventHubs.stream().map(name -> new Event((String)name, (String)name)).collect(Collectors.toSet());
        data.addSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
    }

    private Set<String> getSubscribedEventHubs() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.getSubscribedEventHubsFromEventHubConsumerClient());
        names.addAll(this.getSubscribedEventHubsFromEventHubConsumerAsyncClient());
        return names;
    }

    private Set<String> getSubscribedEventHubsFromEventHubConsumerClient() {
        Map<String, ?> beans = this.context.getBeansOfType("com.azure.messaging.eventhubs.EventHubConsumerClient");
        if (beans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> eventHubFullnames = new HashSet<String>();
        beans.values().forEach(bean -> {
            EventHubConsumerClient client = (EventHubConsumerClient)bean;
            String eventHubName = client.getEventHubName();
            String namespace = client.getFullyQualifiedNamespace();
            String fullName = this.formatName(namespace, eventHubName);
            if (fullName != null && !fullName.isEmpty()) {
                eventHubFullnames.add(fullName);
            }
        });
        return eventHubFullnames;
    }

    private Set<String> getSubscribedEventHubsFromEventHubConsumerAsyncClient() {
        Map<String, ?> beans = this.context.getBeansOfType("com.azure.messaging.eventhubs.EventHubConsumerAsyncClient");
        if (beans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> eventHubFullnames = new HashSet<String>();
        beans.values().forEach(bean -> {
            EventHubConsumerAsyncClient client = (EventHubConsumerAsyncClient)bean;
            String eventHubName = client.getEventHubName();
            String namespace = client.getFullyQualifiedNamespace();
            String fullName = this.formatName(namespace, eventHubName);
            if (fullName != null && !fullName.isEmpty()) {
                eventHubFullnames.add(fullName);
            }
        });
        return eventHubFullnames;
    }

    private Set<Event> getPublishedEventHubs(Set<String> subscribedEventHubs) {
        HashMap<String, Event> publishedEvents = new HashMap<String, Event>();
        this.getPublishedEventHubsFromEventHubProducerClients(subscribedEventHubs).forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        this.getPublishedEventHubsFromEventHubProducerAsyncClients(subscribedEventHubs).forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveEventHubNameFromPublishedByName);
        EventFunctions.addPayloadsToEvents(eventClassToPublishers, publishedEvents);
        return new HashSet<Event>(publishedEvents.values());
    }

    private Set<Event> getPublishedEventHubsFromEventHubProducerClients(Set<String> subscribedEventHubs) {
        Map<String, ?> beans = this.context.getBeansOfType("com.azure.messaging.eventhubs.EventHubProducerClient");
        if (beans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Event> events = new HashSet<Event>();
        beans.values().forEach(bean -> {
            EventHubProducerClient client = (EventHubProducerClient)bean;
            String eventHubName = client.getEventHubName();
            String namespace = client.getFullyQualifiedNamespace();
            String fullName = this.formatName(namespace, eventHubName);
            if (fullName != null && !fullName.isEmpty() && !subscribedEventHubs.contains(fullName)) {
                Event event = new Event(fullName, eventHubName);
                event.addPropertyIfValueNotBlank("Message Broker", "Azure EventHub");
                event.addPropertyIfValueNotBlank("Namespace", namespace);
                event.addPropertyIfValueNotBlank("EventHub Name", eventHubName);
                events.add(event);
            }
        });
        return events;
    }

    private Set<Event> getPublishedEventHubsFromEventHubProducerAsyncClients(Set<String> subscribedEventHubs) {
        Map<String, ?> beans = this.context.getBeansOfType("com.azure.messaging.eventhubs.EventHubProducerAsyncClient");
        if (beans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Event> events = new HashSet<Event>();
        beans.values().forEach(bean -> {
            EventHubProducerAsyncClient client = (EventHubProducerAsyncClient)bean;
            String eventHubName = client.getEventHubName();
            String namespace = client.getFullyQualifiedNamespace();
            String fullName = this.formatName(namespace, eventHubName);
            if (fullName != null && !fullName.isEmpty() && !subscribedEventHubs.contains(fullName)) {
                Event event = new Event(fullName, eventHubName);
                event.addPropertyIfValueNotBlank("Message Broker", "Azure EventHub");
                event.addPropertyIfValueNotBlank("Namespace", namespace);
                event.addPropertyIfValueNotBlank("EventHub Name", eventHubName);
                events.add(event);
            }
        });
        return events;
    }

    private String formatName(String namespace, String eventHubName) {
        String formattedNamespace = this.formatNamespace(namespace);
        if (formattedNamespace.isEmpty()) {
            return eventHubName;
        }
        return formattedNamespace + ":" + eventHubName;
    }

    private String formatNamespace(String namespace) {
        if (namespace == null || namespace.trim().isEmpty()) {
            return "";
        }
        return namespace;
    }

    private String resolveEventHubNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        Optional<Object> optionalBean = this.context.getBeanByName(publishedByName);
        if (optionalBean.isPresent()) {
            Object bean = optionalBean.get();
            if (bean instanceof EventHubProducerClient) {
                EventHubProducerClient client = (EventHubProducerClient)bean;
                String eventHubName = client.getEventHubName();
                String namespace = client.getFullyQualifiedNamespace();
                String fullName = this.formatName(namespace, eventHubName);
                return fullName;
            }
            if (bean instanceof EventHubProducerAsyncClient) {
                EventHubProducerAsyncClient client = (EventHubProducerAsyncClient)bean;
                String eventHubName = client.getEventHubName();
                String namespace = client.getFullyQualifiedNamespace();
                String fullName = this.formatName(namespace, eventHubName);
                return fullName;
            }
            logger.warn("Unable to extract eventhub name of ContextEvent {} since the bean is not a EventHubProducerClient or EventHubProducerAsyncClient, but it's of type {}", eventClass, bean.getClass());
            return "";
        }
        return this.context.resolveSpELStringValue(publishedByName);
    }
}

