/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import com.mongodb.client.MongoCursor;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageEntity;
import io.contextmap.spring.runtime.model.storage.StorageEntityType;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoTemplateMetadataScanner {
    private static final Logger logger = LoggerFactory.getLogger(MongoTemplateMetadataScanner.class);

    public static void enrichMongoWithMetadata(Storage storage, MongoTemplate mongoTemplate) {
        ArrayList<StorageEntity> entities = new ArrayList<StorageEntity>();
        try {
            mongoTemplate.execute(db -> {
                MongoCursor iter = db.listCollectionNames().iterator();
                if (iter.hasNext()) {
                    String name = (String)iter.next();
                    StorageEntity entity = new StorageEntity();
                    entities.add(entity);
                    entity.setName(name);
                    entity.setType(StorageEntityType.COLLECTION);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.debug("Error: " + e.getMessage());
        }
        storage.setEntities(entities);
    }
}

