/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageEntity;
import io.contextmap.spring.runtime.model.storage.StorageEntityType;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;

public class ReactiveMongoTemplateMetadataScanner {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMongoTemplateMetadataScanner.class);

    public static void enrichReactiveMongoWithMetadata(Storage storage, ReactiveMongoTemplate mongoTemplate) {
        ArrayList<StorageEntity> entities = new ArrayList<StorageEntity>();
        try {
            mongoTemplate.execute(MongoDatabase::listCollectionNames).subscribe(name -> {
                StorageEntity entity = new StorageEntity();
                entities.add(entity);
                entity.setName((String)name);
                entity.setType(StorageEntityType.COLLECTION);
            });
        }
        catch (Exception e) {
            logger.debug("Error: " + e.getMessage());
        }
        storage.setEntities(entities);
    }
}

