/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageType;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.storage.mongodb.MongoTemplateMetadataScanner;
import io.contextmap.spring.runtime.scanner.storage.mongodb.ReactiveMongoTemplateMetadataScanner;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;

public class MongoStorageScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(MongoStorageScanner.class);
    private final ScanApplicationContext context;

    public MongoStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        logger.debug("Scanning MongoDB storages");
        data.getExecution().setScannedStorages(true);
        data.addStorages(this.getMongoStoragesFromTemplates());
        data.addStorages(this.getMongoStoragesFromReactiveTemplates());
    }

    private List<Storage> getMongoStoragesFromTemplates() {
        Map<String, ?> templates = this.context.getBeansOfType("org.springframework.data.mongodb.core.MongoTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<Storage> getMongoStoragesFromReactiveTemplates() {
        Map<String, ?> templates = this.context.getBeansOfType("org.springframework.data.mongodb.core.ReactiveMongoTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Storage> convertToStorage(MongoTemplate mongoTemplate) {
        Document buildInfoDocument = mongoTemplate.executeCommand("{ buildInfo: 1 }");
        Object dbVersion = buildInfoDocument.get((Object)"version");
        String dbName = mongoTemplate.getDb().getName();
        if (dbName == null || dbName.isEmpty()) {
            dbName = "MongoDB";
        }
        Storage storage = new Storage();
        storage.setName(dbName);
        storage.setType(StorageType.MONGODB);
        if (dbVersion != null) {
            storage.addProperty("Version", String.valueOf(dbVersion));
            storage.addProperty("Name", "MongoDB");
        }
        MongoTemplateMetadataScanner.enrichMongoWithMetadata(storage, mongoTemplate);
        return Optional.of(storage);
    }

    private Optional<Storage> convertToStorage(ReactiveMongoTemplate mongoTemplate) {
        try {
            Document buildInfoDocument = (Document)mongoTemplate.executeCommand("{ buildInfo: 1 }").block(Duration.ofSeconds(20L));
            Object dbVersion = buildInfoDocument == null ? null : buildInfoDocument.get((Object)"version");
            Method method = mongoTemplate.getClass().getDeclaredMethod("getMongoDatabase", new Class[0]);
            String dbName = method.getReturnType().getSimpleName().equals("Mono") ? ((MongoDatabase)mongoTemplate.getMongoDatabase().block(Duration.ofSeconds(20L))).getName() : ((MongoDatabase)mongoTemplate.getMongoDatabase()).getName();
            if (dbName == null || dbName.isEmpty()) {
                dbName = "MongoDB";
            }
            Storage storage = new Storage();
            storage.setName(dbName);
            storage.setType(StorageType.MONGODB);
            if (dbVersion != null) {
                storage.addProperty("Version", String.valueOf(dbVersion));
                storage.addProperty("Name", "MongoDB");
            }
            ReactiveMongoTemplateMetadataScanner.enrichReactiveMongoWithMetadata(storage, mongoTemplate);
            return Optional.of(storage);
        }
        catch (Exception e) {
            logger.info("Unable to scan reactive mongo due to: " + e.getMessage());
            logger.debug("Error:", (Throwable)e);
            return Optional.empty();
        }
    }
}

