/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.DecisionRecordOverview;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DecisionRecordVisitor
extends SimpleFileVisitor<Path> {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private List<DecisionRecordOverview> decisionRecords = new ArrayList<DecisionRecordOverview>();

    public List<DecisionRecordOverview> getDecisionRecords() {
        return this.decisionRecords;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
        try {
            FileVisitResult result = super.visitFile(file, attr);
            if (attr.isSymbolicLink() || !attr.isRegularFile()) {
                return result;
            }
            if ("MD".equals(this.getExtension(file.getFileName().toString())) || "AD".equals(this.getExtension(file.getFileName().toString())) || "ADR".equals(this.getExtension(file.getFileName().toString()))) {
                DecisionRecordOverview adr = new DecisionRecordOverview();
                adr.filePath = file;
                adr.name = file.getFileName().toString();
                adr.contentHash = this.createContentHash(file);
                this.decisionRecords.add(adr);
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getExtension(String filename) {
        if (filename.contains(".")) {
            return filename.substring(filename.lastIndexOf(46) + 1).toUpperCase(Locale.US);
        }
        return "";
    }

    private String createContentHash(Path file) throws Exception {
        byte[] b = Files.readAllBytes(file);
        byte[] digest = MessageDigest.getInstance("MD5").digest(b);
        return this.printHexBinary(digest);
    }

    private String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }
}

