/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.ActionType;
import iBoxDB.LocalServer.Binder;
import iBoxDB.LocalServer.FileChannel;
import iBoxDB.LocalServer.LocalHashMap;
import iBoxDB.LocalServer.OPEntity;

public abstract class AbstractBox {
    final long localAddress;
    final long destAddress;

    public AbstractBox(long localAddress, long destAddress) {
        this.localAddress = localAddress;
        this.destAddress = destAddress;
    }

    public long localAddress() {
        return this.localAddress;
    }

    public long destAddress() {
        return this.destAddress;
    }

    public abstract <R> R Action(OPEntity var1) throws RuntimeException;

    protected <K, V, R> R CallAction(String tableName, ActionType actionType, K k2, V v2) {
        return this.Action(OPEntity.CreateAction(tableName, actionType, k2, v2));
    }

    public Iterable<LocalHashMap> select(String QL, Object ... arguments) throws RuntimeException {
        return this.select(LocalHashMap.class, QL, arguments);
    }

    public <V> Iterable<V> select(Class<V> vClass, String QL, Object ... arguments) throws RuntimeException {
        return (Iterable)this.CallAction(QL, ActionType.Select, arguments, vClass);
    }

    public long selectCount(String QL, Object ... arguments) throws RuntimeException {
        return (Long)this.CallAction(QL, ActionType.SelectCount, arguments, null);
    }

    public byte[] execute(byte[] args) throws RuntimeException {
        return (byte[])this.CallAction(null, ActionType.Execute, args, null);
    }

    public long newId(int name, long step) throws RuntimeException {
        return (Long)this.CallAction(null, ActionType.NewId, (short)name, step);
    }

    public <V> boolean insert(String tableName, V value) throws RuntimeException {
        return this.bind(tableName, (Object)null).insert(value);
    }

    public Binder bind(String tableName) {
        return new Binder(this, tableName, null);
    }

    public Binder bind(String tableName, Object k2) {
        return new Binder(this, tableName, k2);
    }

    public Binder bind(String tableName, Object ... ks) {
        if (ks.length == 1) {
            return new Binder(this, tableName, ks[0]);
        }
        return new Binder(this, tableName, ks);
    }

    public FileChannel fileChannel() {
        return new FileChannel(this);
    }
}

