/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.Binder;
import iBoxDB.LocalServer.Box;
import iBoxDB.LocalServer.Database;
import iBoxDB.LocalServer.LocalHashMap;
import iBoxDB.bytecodes.dl;
import java.util.HashMap;

public class AutoBox {
    private Database ldb;
    private long destAddress;

    protected AutoBox() {
    }

    public AutoBox(Database database, long destAddress) {
        this.Open(database, destAddress);
    }

    protected void Open(Database database, long destAddress) {
        this.ldb = database;
        this.destAddress = destAddress;
    }

    protected int GetTableLength(String table) {
        return -1;
    }

    protected <V> void SetTableID(Box box, String table, V value) {
    }

    protected Box CreateCube() {
        return this.ldb.cube(this.destAddress);
    }

    public byte[] execute(byte[] bs2) throws RuntimeException {
        return this.execute(bs2, true);
    }

    public byte[] execute(byte[] bs2, boolean commit) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            byte[] byArray = box.execute(bs2);
            if (commit) {
                box.commit().Assert();
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            box.close();
        }
    }

    public boolean insert(String table, Object value) throws RuntimeException {
        return this.insert(table, new Object[]{value});
    }

    public <V> boolean insert(String table, V ... values) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            int n2 = this.GetTableLength(table);
            Binder binder = box.bind(table);
            V[] VArray = values;
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                V v2 = VArray[n4];
                this.SetTableID(box, table, v2);
                if (!binder.insert(v2, n2)) {
                    return false;
                }
                ++n4;
            }
            box.commit().Assert();
            return true;
        }
        finally {
            box.close();
        }
    }

    public <V> boolean update(String table, Object key, V value) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            int n2 = this.GetTableLength(table);
            if (box.bind(table, key).update(value, n2)) {
                box.commit().Assert();
                return true;
            }
            return false;
        }
        finally {
            box.close();
        }
    }

    public <V> boolean update(String table, Object[] keies, V value) throws RuntimeException {
        return this.update(table, (Object)keies, value);
    }

    public <V> boolean update(String table, V value) throws RuntimeException {
        return this.update(table, value, value);
    }

    public <V> boolean updateNoIndex(String table, Object key, V value) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            if (box.bind(table, key).updateNoIndex(value)) {
                box.commit().Assert();
                return true;
            }
            return false;
        }
        finally {
            box.close();
        }
    }

    public <V> boolean updateNoIndex(String table, V value) throws RuntimeException {
        return this.updateNoIndex(table, value, value);
    }

    public <V> boolean updateNoIndex(String table, Object[] keies, V value) throws RuntimeException {
        return this.updateNoIndex(table, (Object)keies, value);
    }

    public boolean delete(String table, Object key) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            if (box.bind(table, key).delete()) {
                box.commit().Assert();
                return true;
            }
            return false;
        }
        finally {
            box.close();
        }
    }

    public boolean delete(String table, Object ... key) throws RuntimeException {
        return this.delete(table, (Object)key);
    }

    public <V> boolean replace(String table, V value) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            int n2 = this.GetTableLength(table);
            if (!box.bind(table, (Object)value).update(value, n2)) {
                box.bind(table).insert(value, n2);
            }
            box.commit().Assert();
            return true;
        }
        finally {
            box.close();
        }
    }

    public <V> boolean replaceNoIndex(String table, V value) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            if (!box.bind(table, (Object)value).updateNoIndex(value)) {
                int n2 = this.GetTableLength(table);
                box.bind(table).insert(value, n2);
            }
            box.commit().Assert();
            return true;
        }
        finally {
            box.close();
        }
    }

    public <V> Iterable<V> select(Class<V> aClass, String QL, Object ... arguments) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            Iterable<V> iterable = dl.b(box.select(aClass, QL, arguments));
            return iterable;
        }
        finally {
            box.close();
        }
    }

    public Iterable<LocalHashMap> select(String QL, Object ... arguments) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            Iterable<LocalHashMap> iterable = dl.b(box.select(QL, arguments));
            return iterable;
        }
        finally {
            box.close();
        }
    }

    public long selectCount(String QL, Object ... arguments) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            long l2 = box.selectCount(QL, arguments);
            return l2;
        }
        finally {
            box.close();
        }
    }

    public long newId(int name, long step) {
        Box box = this.CreateCube();
        try {
            long l2 = box.newId(name, step);
            if (step != 0L) {
                box.commit().Assert();
            }
            long l3 = l2;
            return l3;
        }
        finally {
            box.close();
        }
    }

    public <V> V selectKey(Class<V> aclass, String table, Object key) throws RuntimeException {
        Box box = this.CreateCube();
        try {
            V v2 = box.bind(table, key).select(aclass);
            return v2;
        }
        finally {
            box.close();
        }
    }

    public HashMap<String, Object> selectKey(String table, Object key) throws RuntimeException {
        return this.selectKey((Class<V>)HashMap.class, table, key);
    }

    public HashMap<String, Object> selectKey(String table, Object ... key) throws RuntimeException {
        return this.selectKey(table, (Object)key);
    }

    public <V> V selectKey(Class<V> aclass, String table, Object ... key) throws RuntimeException {
        return this.selectKey(aclass, table, (Object)key);
    }
}

