/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.AbstractBox;
import iBoxDB.LocalServer.LocalHashMap;
import iBoxDB.LocalServer.OPEntity;
import java.util.HashMap;

public final class Binder {
    public final AbstractBox Box;
    public final Object Key;
    public final String TableName;
    private LocalHashMap ro;

    protected Binder(AbstractBox s2, String tableName, Object k2) {
        this.Box = s2;
        this.Key = k2;
        this.TableName = tableName;
        this.ro = null;
    }

    public Object get(String name) {
        return this.Readonly().get(name);
    }

    public String toString() {
        LocalHashMap localHashMap = this.Readonly();
        if (localHashMap == null) {
            return null;
        }
        return localHashMap.toString();
    }

    LocalHashMap Readonly() {
        if (this.ro == null) {
            this.ro = this.select(LocalHashMap.class);
        }
        return this.ro;
    }

    public HashMap<String, Object> select() throws RuntimeException {
        return this.select(false);
    }

    public HashMap<String, Object> select(boolean keep) throws RuntimeException {
        return this.select(HashMap.class, keep);
    }

    public <V> V select(Class<V> vClass) throws RuntimeException {
        return this.select(vClass, false);
    }

    public <V> V select(Class<V> vClass, boolean keep) throws RuntimeException {
        return (V)this.Box.Action(OPEntity.makeSelectByKey(this.TableName, keep, this.Key, vClass));
    }

    public <V> boolean insert(V value) throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeInsert(this.TableName, value));
    }

    public <V> boolean update(V value) throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeUpdate(this.TableName, this.Key, value));
    }

    protected <V> boolean insert(V value, int reLength) throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeInsert(this.TableName, value, reLength));
    }

    protected <V> boolean update(V value, int reLength) throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeUpdate(this.TableName, this.Key, value, reLength));
    }

    public <V> boolean updateNoIndex(V value) throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeUpdateNoIndex(this.TableName, this.Key, value));
    }

    public boolean delete() throws RuntimeException {
        return (Boolean)this.Box.Action(OPEntity.makeDelete(this.TableName, this.Key));
    }
}

