/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.AbstractBox;
import iBoxDB.LocalServer.Box;
import iBoxDB.LocalServer.Database;
import iBoxDB.LocalServer.DatabaseConfig;
import iBoxDB.LocalServer.GlobalDatabaseConfig;
import iBoxDB.LocalServer.IO.BoxFileStreamConfig;
import iBoxDB.LocalServer.IO.BoxMemoryStreamConfig;
import iBoxDB.LocalServer.LocalDatabaseServer;
import iBoxDB.LocalServer.LocalHashMap;
import iBoxDB.LocalServer.Replication.IBoxRecycler;
import iBoxDB.bytecodes.cf;
import iBoxDB.bytecodes.cn;
import iBoxDB.bytecodes.da;
import iBoxDB.bytecodes.dj;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DB
implements Closeable {
    private static final Object Sync = new Object();
    private volatile Database ldb;
    private DatabaseConfig config;
    private long address;
    private dj<String, TableSetting> tableLengths;

    public static void root(String path) {
        if (path != null && path.length() > 0) {
            boolean bl2 = path.contains("\\");
            if (!path.endsWith("\\") && !path.endsWith("/")) {
                path = bl2 ? String.valueOf(path) + "\\" : String.valueOf(path) + "/";
            }
            BoxFileStreamConfig.BaseDirectory = path;
        }
    }

    public DB(InputStream data) {
        this(cf.a(data));
    }

    public DB(byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        this.address = 1L;
        this.config = new MMConfig((byte[])data.clone());
        this.config.CachePageCount = 64;
        this.config.FileIncSize = 1;
        this.tableLengths = new dj(32);
    }

    public byte[] GetBuffer() {
        if (this.config instanceof BoxMemoryStreamConfig) {
            return ((BoxMemoryStreamConfig)this.config).getBuffer();
        }
        return null;
    }

    public DB(long localAddress, String path) {
        this.address = localAddress;
        DB.root(path);
        this.config = new FConfig();
        this.tableLengths = new dj(256);
    }

    public DB() {
        this(1L);
    }

    public DB(String path) {
        this(1L, path);
    }

    public DB(long address) {
        this(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoBox open() {
        Object object = this;
        synchronized (object) {
            if (this.ldb == null) {
                this.ldb = new FDS(this.config, null).getInstance(this.address);
            }
        }
        object = new AutoBox();
        ((iBoxDB.LocalServer.AutoBox)object).Open(this.ldb, 0L);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RuntimeException {
        DB dB = this;
        synchronized (dB) {
            if (this.ldb != null) {
                this.ldb.close();
                this.ldb = null;
            }
        }
    }

    public boolean isClosed() {
        return this.ldb == null;
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public DatabaseConfig minConfig() {
        GlobalDatabaseConfig.Cache_SwapFileBuffer = 65536;
        GlobalDatabaseConfig.Cache_DynamicObjectLength = 8192;
        this.config.CachePageCount = 64;
        this.config.FileIncSize = 65536;
        return this.config;
    }

    public DB ensureTable(Class<?> aclass, String tableName, String ... names) {
        this.config.EnsureTable(aclass, tableName, names);
        TableSetting tableSetting = new TableSetting();
        tableSetting.Length = -1;
        tableSetting.AutoIDMap = -1;
        tableSetting.AutoIDNames = (String[])names.clone();
        tableSetting.AutoIDTypes = new Class[names.length];
        this.tableLengths.a(tableName, tableSetting);
        cn cn2 = cn.a(aclass);
        int n2 = 0;
        while (n2 < names.length) {
            tableSetting.AutoIDTypes[n2] = cn2.b(null, names[n2]);
            ++n2;
        }
        return this;
    }

    public DB ensureTable(String tableName, Map<String, Object> protoType) {
        return this.ensureTable(tableName, protoType, null);
    }

    public DB ensureTable(String tableName, Map<String, Object> protoType, String ... names) {
        Object object = Sync;
        synchronized (object) {
            DB dB;
            cn.b.b = new dj<String, Object>(DB.ToHashMap(protoType));
            try {
                if (names == null || names.length < 1 || names[0] == null) {
                    names = protoType.keySet().toArray(new String[protoType.size()]);
                }
                dB = this.ensureTable(LocalHashMap.class, tableName, names);
                cn.b.b = null;
            }
            catch (Throwable throwable) {
                cn.b.b = null;
                throw throwable;
            }
            return dB;
        }
    }

    public DB ensureParameters(String tableName, int autoIncrementIDName, int defaultRecordLength) {
        this.tableLengths.a((String)tableName).AutoIDMap = autoIncrementIDName <= 0 ? -1 : autoIncrementIDName;
        this.tableLengths.a((String)tableName).Length = defaultRecordLength <= 0 ? -1 : defaultRecordLength;
        return this;
    }

    public DB ensureIndex(Class<?> aclass, String tableName, boolean isUnique, String ... names) {
        this.config.EnsureIndex(aclass, tableName, isUnique, names);
        return this;
    }

    public DB ensureIndex(Class<?> aclass, String tableName, String ... names) {
        return this.ensureIndex(aclass, tableName, false, names);
    }

    public DB ensureIndex(String tableName, Map<String, Object> protoType, boolean isUnique) {
        return this.ensureIndex(tableName, protoType, isUnique, null);
    }

    public DB ensureIndex(String tableName, Map<String, Object> protoType) {
        return this.ensureIndex(tableName, protoType, false);
    }

    public DB ensureIndex(String tableName, Map<String, Object> protoType, boolean isUnique, String ... names) {
        Object object = Sync;
        synchronized (object) {
            DB dB;
            cn.b.b = new dj<String, Object>(DB.ToHashMap(protoType));
            try {
                if (names == null || names.length < 1 || names[0] == null) {
                    names = protoType.keySet().toArray(new String[protoType.size()]);
                }
                dB = this.ensureIndex(LocalHashMap.class, tableName, isUnique, names);
                cn.b.b = null;
            }
            catch (Throwable throwable) {
                cn.b.b = null;
                throw throwable;
            }
            return dB;
        }
    }

    public DB ensureIndex(String tableName, Map<String, Object> protoType, String ... names) {
        return this.ensureIndex(tableName, protoType, false, names);
    }

    public DB ensureUpdateIncrementIndex(Class<?> aclass, String tableName, String ... names) {
        this.config.EnsureUpdateIncrementIndex(aclass, tableName, names);
        return this;
    }

    public DB ensureUpdateIncrementIndex(String tableName, Map<String, Object> protoType, String ... names) {
        Object object = Sync;
        synchronized (object) {
            DB dB;
            cn.b.b = new dj<String, Object>(DB.ToHashMap(protoType));
            try {
                if (names == null || names.length < 1 || names[0] == null) {
                    names = protoType.keySet().toArray(new String[protoType.size()]);
                }
                dB = this.ensureUpdateIncrementIndex(LocalHashMap.class, tableName, names);
                cn.b.b = null;
            }
            catch (Throwable throwable) {
                cn.b.b = null;
                throw throwable;
            }
            return dB;
        }
    }

    private static Map<String, Object> amap(Map<String, Object> map, Object ... values) {
        int n2 = 0;
        while (n2 < values.length) {
            map.put((String)values[n2], values[n2 + 1]);
            n2 += 2;
        }
        return map;
    }

    public static HashMap<String, Object> map(Object ... values) {
        if (values.length == 1) {
            Object object = values[0];
            if (object instanceof Map) {
                return new HashMap<String, Object>((Map)object);
            }
            return da.a(object);
        }
        return (HashMap)DB.amap(new HashMap<String, Object>(), values);
    }

    public static LinkedHashMap<String, Object> omap(Object ... values) {
        return (LinkedHashMap)DB.amap(new LinkedHashMap<String, Object>(), values);
    }

    public static Object[] array() {
        return new Object[0];
    }

    public static Object[] array(Object a1) {
        if (a1 instanceof Iterable) {
            return DB.array((Iterable)a1);
        }
        return new Object[]{a1};
    }

    public static Object[] array(Object[] a1, Object a2) {
        Object[] objectArray = new Object[a1.length + 1];
        System.arraycopy(a1, 0, objectArray, 0, a1.length);
        objectArray[objectArray.length - 1] = a2;
        return objectArray;
    }

    public static Object[] array(Iterable<?> a1) {
        ArrayList arrayList = new ArrayList();
        for (Object obj : a1) {
            arrayList.add(obj);
        }
        return arrayList.toArray();
    }

    private static HashMap<String, Object> ToHashMap(Map<String, Object> protoType) {
        if (protoType instanceof HashMap) {
            return (HashMap)protoType;
        }
        return new HashMap<String, Object>(protoType);
    }

    public final class AutoBox
    extends iBoxDB.LocalServer.AutoBox {
        public Box cube() {
            return super.CreateCube();
        }

        @Override
        protected int GetTableLength(String table) {
            int n2 = -1;
            TableSetting tableSetting = (TableSetting)DB.this.tableLengths.a(table);
            if (tableSetting != null) {
                n2 = tableSetting.Length;
            }
            return n2;
        }

        @Override
        protected <V> void SetTableID(Box box, String table, V value) {
            TableSetting tableSetting = (TableSetting)DB.this.tableLengths.a(table);
            if (tableSetting != null && tableSetting.AutoIDMap > 0) {
                Object object = this.newId(box, tableSetting.AutoIDMap, 1L, tableSetting.AutoIDTypes[0]);
                cn.a(value.getClass()).a(value, tableSetting.AutoIDNames[0], object);
            }
        }

        protected Object newId(AbstractBox box, int name, long step, Class<?> type) {
            if (type == Integer.class) {
                return (int)box.newId(name, step);
            }
            if (type == Long.class) {
                return box.newId(name, step);
            }
            if (type == Double.class) {
                return (double)box.newId(name, step);
            }
            if (type == String.class) {
                return Long.toString(box.newId(name, step));
            }
            return null;
        }

        public Iterable<LocalHashMap> select(String QL, Object arguments) throws RuntimeException {
            if (arguments instanceof Object[]) {
                return super.select(QL, (Object[])arguments);
            }
            return super.select(QL, arguments);
        }

        public Iterable<LocalHashMap> select(String QL) throws RuntimeException {
            return super.select(QL, new Object[0]);
        }

        public long selectCount(String QL, Object arguments) throws RuntimeException {
            if (arguments instanceof Object[]) {
                return super.selectCount(QL, (Object[])arguments);
            }
            return super.selectCount(QL, arguments);
        }

        public long selectCount(String QL) throws RuntimeException {
            return super.selectCount(QL, new Object[0]);
        }

        public int newIntId(int name, int step) {
            return (int)super.newId(name, step);
        }
    }

    private static final class FConfig
    extends BoxFileStreamConfig {
        private FConfig() {
        }

        @Override
        public void close() {
        }
    }

    private static final class FDS
    extends LocalDatabaseServer {
        final DatabaseConfig cfg;
        final IBoxRecycler recycer;

        public FDS(DatabaseConfig cfg, IBoxRecycler recycer) {
            this.cfg = cfg;
            this.recycer = recycer;
        }

        @Override
        protected DatabaseConfig BuildDatabaseConfig(long address) {
            return this.cfg;
        }

        @Override
        protected IBoxRecycler BuildBoxRecycler(long address, DatabaseConfig config) {
            return this.recycer;
        }
    }

    private static final class MMConfig
    extends BoxMemoryStreamConfig {
        public MMConfig(byte[] clone) {
            super(clone);
        }

        @Override
        public void close() {
        }
    }

    private static final class TableSetting {
        public int Length = -1;
        public String[] AutoIDNames;
        public Class<?>[] AutoIDTypes;
        public int AutoIDMap;

        private TableSetting() {
        }
    }
}

