/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.IO.FileAccess;
import iBoxDB.LocalServer.IO.Stream;
import iBoxDB.LocalServer.SwapType;
import iBoxDB.bytecodes.ay;
import iBoxDB.bytecodes.az;
import java.io.Closeable;
import java.util.UUID;

public abstract class DatabaseConfig
implements Closeable {
    public int FileIncSize = 131072;
    public int CachePageCount = 1024;
    private ay _metadatas = new ay();

    public abstract Stream CreateStream(String var1, FileAccess var2);

    public abstract boolean ExistsStream(String var1);

    protected DatabaseConfig() {
    }

    public SwapType GetSwapType() {
        return SwapType.Last;
    }

    public String GetDataBaseCreater() {
        return UUID.randomUUID().toString();
    }

    public Object Metadata() {
        return this._metadatas;
    }

    public void Metadata(Object dict) {
        this._metadatas = (ay)dict;
    }

    public <T> void EnsureTable(Class<T> aclass, String tableName, String ... names) {
        this._metadatas.a(az.a(aclass, tableName, names));
    }

    public <T> void EnsureIndex(Class<T> aclass, String tableName, boolean isUnique, String ... names) {
        ((az)this._metadatas.c(tableName)).a(aclass, isUnique, names);
    }

    public <T> void EnsureIndex(Class<T> aclass, String tableName, String ... names) {
        this.EnsureIndex(aclass, tableName, false, names);
    }

    public <T> void EnsureUpdateIncrementIndex(Class<T> aclass, String tableName, String ... names) {
        ((az)this._metadatas.c(tableName)).a(aclass, names);
    }

    public boolean IsStreamSupported(String path) {
        Stream stream = this.CreateStream(path, FileAccess.Write);
        try {
            if (stream.Length() > 0L) {
                return false;
            }
            Stream stream2 = this.CreateStream(path, FileAccess.Read);
            if (stream2 == stream) {
                return false;
            }
            stream.Write(new byte[]{3}, 0, 1);
            stream.Flush();
            byte[] byArray = new byte[1];
            stream2.Read(byArray, 0, 1);
            if (byArray[0] == 3) {
                stream.Position(0L);
                stream.Write(new byte[]{4}, 0, 1);
                stream.Flush();
                stream2.Position(0L);
                stream2.Read(byArray, 0, 1);
                if (byArray[0] != 4) {
                    return false;
                }
            } else {
                return false;
            }
            stream2.Dispose();
            stream.SetLength(0L);
            stream.Flush();
            return true;
        }
        finally {
            stream.Dispose();
        }
    }

    @Override
    public void close() {
    }

    public static String GetNameByAddrDefault(long address) {
        return "db" + Long.toString(address).replace('-', '_') + ".ibx";
    }
}

