/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer.IO;

import iBoxDB.LocalServer.DatabaseConfig;
import iBoxDB.LocalServer.IO.FileAccess;
import iBoxDB.LocalServer.IO.Stream;
import iBoxDB.bytecodes.b;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.OverlappingFileLockException;

public class BoxFileStreamConfig
extends DatabaseConfig {
    public static String BaseDirectory = "";
    public static boolean SingleProcess = true;
    private boolean FlushToDisk;

    public BoxFileStreamConfig() {
        this(false);
    }

    public BoxFileStreamConfig(boolean flushAndClear) {
        this.CachePageCount = 131072;
        this.FileIncSize = 0x200000;
        this.FlushToDisk = flushAndClear;
    }

    @Override
    public Stream CreateStream(String path, FileAccess access) throws RuntimeException {
        try {
            path = String.valueOf(BaseDirectory) + path;
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            return new BStream(file, access);
        }
        catch (Throwable throwable) {
            return (Stream)b.a(throwable);
        }
    }

    @Override
    public boolean ExistsStream(String path) {
        path = String.valueOf(BaseDirectory) + path;
        File file = new File(path);
        return file.exists();
    }

    protected void DoFlush(RandomAccessFile file) throws RuntimeException {
        try {
            file.getFD().sync();
        }
        catch (Throwable throwable) {
            b.a(throwable);
        }
    }

    protected final class BStream
    implements Stream {
        RandomAccessFile rFile;
        private boolean isw = false;

        public BStream(File f2, FileAccess access) {
            String string = "";
            if (access == FileAccess.Read) {
                string = "r";
                this.isw = false;
            } else if (access == FileAccess.Write) {
                string = "rw";
                this.isw = true;
            } else if (access == FileAccess.ReadWrite) {
                string = "rw";
                this.isw = true;
            }
            try {
                this.rFile = new RandomAccessFile(f2, string);
                if (SingleProcess && access != FileAccess.Read) {
                    long l2 = 0x7FFFFFFFFFFFFFFBL;
                    if (this.rFile.getChannel().tryLock(l2, 1L, false) == null) {
                        this.rFile.close();
                        this.rFile = null;
                        throw new OverlappingFileLockException();
                    }
                }
            }
            catch (Throwable throwable) {
                b.a(throwable);
            }
        }

        @Override
        public void Dispose() {
            try {
                this.rFile.close();
                this.rFile = null;
            }
            catch (IOException iOException) {
                b.a(iOException);
            }
        }

        @Override
        public void Flush() {
            if (BoxFileStreamConfig.this.FlushToDisk) {
                BoxFileStreamConfig.this.DoFlush(this.rFile);
            }
        }

        @Override
        public long Length() {
            try {
                return this.rFile.length();
            }
            catch (IOException iOException) {
                return (Long)b.a(iOException);
            }
        }

        @Override
        public void SetLength(long value) {
            try {
                this.rFile.setLength(value);
            }
            catch (IOException iOException) {
                b.a(iOException);
            }
        }

        @Override
        public long Position() {
            try {
                return this.rFile.getFilePointer();
            }
            catch (IOException iOException) {
                return (Long)b.a(iOException);
            }
        }

        @Override
        public void Position(long position) {
            try {
                this.rFile.seek(position);
            }
            catch (IOException iOException) {
                b.a(iOException);
            }
        }

        @Override
        public int Read(byte[] buffer, int offset, int count) {
            try {
                return this.rFile.read(buffer, offset, count);
            }
            catch (IOException iOException) {
                return (Integer)b.a(iOException);
            }
        }

        @Override
        public void Write(byte[] buffer, int offset, int count) {
            try {
                this.rFile.write(buffer, offset, count);
            }
            catch (IOException iOException) {
                b.a(iOException);
            }
        }

        public RandomAccessFile GetRandomAccessFile() {
            return this.rFile;
        }
    }
}

