/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer.IO;

import iBoxDB.LocalServer.DatabaseConfig;
import iBoxDB.LocalServer.IO.FileAccess;
import iBoxDB.LocalServer.IO.Stream;
import iBoxDB.LocalServer.SwapType;
import iBoxDB.bytecodes.b;
import iBoxDB.bytecodes.dj;

public class BoxMemoryStreamConfig
extends DatabaseConfig {
    private byte[] buffer;
    private String spath;
    private dj<String, BoxMemoryStreamConfig> dict = new dj();

    public BoxMemoryStreamConfig(byte[] bs2) {
        this.FileIncSize = 0x1400000;
        this.buffer = bs2;
    }

    public BoxMemoryStreamConfig() {
        this(new byte[0]);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public Stream CreateStream(String path, FileAccess access) {
        if (this.GetSwapType() != SwapType.None) {
            return (Stream)b.a("SwapType.None");
        }
        if (this.spath == null) {
            this.spath = path;
        }
        if (this.spath.equals(path)) {
            return new BStream();
        }
        BoxMemoryStreamConfig boxMemoryStreamConfig = this.dict.a(path);
        if (boxMemoryStreamConfig == null) {
            boxMemoryStreamConfig = new BoxMemoryStreamConfig();
            this.dict.a(path, boxMemoryStreamConfig);
        }
        return boxMemoryStreamConfig.CreateStream(path, access);
    }

    @Override
    public boolean ExistsStream(String path) {
        return path.equals(this.spath) || this.dict.b(path);
    }

    @Override
    public SwapType GetSwapType() {
        return SwapType.None;
    }

    private final class BStream
    implements Stream {
        private int pos;

        private BStream() {
        }

        @Override
        public void Dispose() {
        }

        @Override
        public void Flush() {
        }

        @Override
        public long Length() {
            return BoxMemoryStreamConfig.this.buffer.length;
        }

        @Override
        public void SetLength(long value) {
            if (value >= Integer.MAX_VALUE) {
                b.a(Long.toString(value));
                return;
            }
            if (value > (long)BoxMemoryStreamConfig.this.buffer.length) {
                byte[] byArray = new byte[(int)value];
                System.arraycopy(BoxMemoryStreamConfig.this.buffer, 0, byArray, 0, BoxMemoryStreamConfig.this.buffer.length);
                BoxMemoryStreamConfig.this.buffer = byArray;
            }
        }

        @Override
        public long Position() {
            return this.pos;
        }

        @Override
        public void Position(long position) {
            if (position >= Integer.MAX_VALUE) {
                b.a(Long.toString(position));
                return;
            }
            this.pos = (int)position;
        }

        @Override
        public int Read(byte[] rbuffer, int offset, int count) {
            System.arraycopy(BoxMemoryStreamConfig.this.buffer, this.pos, rbuffer, offset, count);
            this.pos += count;
            return count;
        }

        @Override
        public void Write(byte[] wbuffer, int offset, int count) {
            System.arraycopy(wbuffer, offset, BoxMemoryStreamConfig.this.buffer, this.pos, count);
            this.pos += count;
        }
    }
}

