/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.ActionType;
import iBoxDB.LocalServer.Box;
import iBoxDB.LocalServer.CommitResult;
import iBoxDB.LocalServer.Database;
import iBoxDB.LocalServer.DatabaseConfig;
import iBoxDB.LocalServer.DatabaseServer;
import iBoxDB.LocalServer.OPEntity;
import iBoxDB.LocalServer.Replication.IBoxRecycler;
import iBoxDB.LocalServer.Replication.Socket;
import iBoxDB.bytecodes.ar;
import iBoxDB.bytecodes.as;
import iBoxDB.bytecodes.az;
import iBoxDB.bytecodes.b;
import iBoxDB.bytecodes.bb;
import iBoxDB.bytecodes.be;
import iBoxDB.bytecodes.bh;
import iBoxDB.bytecodes.bi;
import iBoxDB.bytecodes.bx;
import iBoxDB.bytecodes.bz;
import iBoxDB.bytecodes.dd;
import iBoxDB.bytecodes.de;
import iBoxDB.bytecodes.di;
import iBoxDB.bytecodes.dj;
import iBoxDB.bytecodes.dk;
import iBoxDB.bytecodes.dl;
import iBoxDB.bytecodes.k;
import iBoxDB.bytecodes.n;
import iBoxDB.bytecodes.x;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public abstract class LocalDatabaseServer
extends DatabaseServer {
    private dj<Long, LocalDatabase> databases = new dj();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RuntimeException {
        if (this.databases != null) {
            dj<Long, LocalDatabase> dj2 = this.databases;
            synchronized (dj2) {
                dl<LocalDatabase> dl2 = new dl<LocalDatabase>(this.databases.d());
                for (LocalDatabase localDatabase : dl2) {
                    localDatabase.close();
                }
                this.databases = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemoveFromDataBases(long address) {
        dj<Long, LocalDatabase> dj2 = this.databases;
        synchronized (dj2) {
            this.databases.d(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database getInstance(long address) {
        LocalDatabase localDatabase;
        dj<Long, LocalDatabase> dj2 = this.databases;
        synchronized (dj2) {
            localDatabase = this.databases.a(address);
            if (localDatabase == null) {
                if (address == 0L) {
                    b.a("Address==0");
                }
                DatabaseConfig databaseConfig = this.BuildDatabaseConfig(address);
                IBoxRecycler iBoxRecycler = this.BuildBoxRecycler(address, databaseConfig);
                String string = this.GetNameByAddr(address);
                ar ar2 = new ar(address, string, databaseConfig, iBoxRecycler);
                String string2 = null;
                if (ar2.d) {
                    string2 = as.a(ar2);
                }
                localDatabase = new LocalDatabase(this, ar2);
                localDatabase.MSG_EX_EnsureIndex = string2;
                this.databases.a(address, localDatabase);
            }
        }
        return localDatabase;
    }

    protected String GetNameByAddr(long address) {
        return DatabaseConfig.GetNameByAddrDefault(address);
    }

    protected IBoxRecycler BuildBoxRecycler(long address, DatabaseConfig config) {
        return null;
    }

    protected byte[] Execute(Box box, byte[] args) {
        byte[] byArray = new byte[]{101, 99, 104, 111};
        if (args == null || args.length < 1) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + args.length];
        di.a(byArray, 0, byArray2, 0, byArray.length);
        di.a(args, 0, byArray2, byArray.length, args.length);
        return byArray2;
    }

    protected abstract DatabaseConfig BuildDatabaseConfig(long var1);

    public static final class LocalBox
    extends Box {
        private n boxSessionImpl;
        private LocalDatabaseServer server;

        public LocalBox(long localAddress, long destAddress, LocalDatabaseServer server, n boxSessionImpl) {
            super(localAddress, destAddress);
            this.boxSessionImpl = boxSessionImpl;
            this.server = server;
        }

        public CommitResult commit(byte[] ... outBox) {
            return (CommitResult)this.CallAction(null, ActionType.Commit, outBox, null);
        }

        public Socket GetSocket() {
            return this.boxSessionImpl.b().e;
        }

        public HashMap<String, Object> GetSchemas() {
            bb bb2 = this.boxSessionImpl.g();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator<az> iterator = bb2.b().iterator();
            while (iterator.hasNext()) {
                az az2;
                az az3 = az2 = iterator.next();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap.put(az3.b, hashMap2);
                hashMap2.put("TableName", az3.b);
                ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
                hashMap2.put("Indexes", arrayList);
                for (az.c c2 : az3.d) {
                    hashMap2 = new HashMap();
                    arrayList.add(hashMap2);
                    hashMap2.put("TableName", c2.b);
                    hashMap2.put("IndexName", c2.a);
                    hashMap2.put("IsKey", c2.e);
                    hashMap2.put("IsUnique", c2.c);
                    ArrayList<HashMap<String, Object>> arrayList2 = new ArrayList<HashMap<String, Object>>();
                    hashMap2.put("Columns", arrayList2);
                    az.b[] bArray = c2.d;
                    int n2 = c2.d.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        az.b b2 = bArray[n3];
                        hashMap2 = new HashMap();
                        arrayList2.add(hashMap2);
                        hashMap2.put("Name", b2.a);
                        hashMap2.put("Type", b2.b.b);
                        hashMap2.put("Length", b2.c);
                        ++n3;
                    }
                }
            }
            return hashMap;
        }

        public String GetIndexName(String QL) {
            bh.b b2 = be.a(QL, this.boxSessionImpl);
            return bi.a(b2);
        }

        public String GetExpression(String QL) {
            bh.b b2 = be.a(QL, this.boxSessionImpl);
            return b2.toString();
        }

        @Override
        public void close() {
            this.boxSessionImpl = (n)bx.a(this.boxSessionImpl);
        }

        private boolean GetTableRelatedIsEmpty() {
            bb bb2 = this.boxSessionImpl.g();
            return bb2 == null || bb2.c() == 0;
        }

        @Override
        public <R> R Action(OPEntity op) {
            switch (op.ActionType.Ord) {
                case 1: {
                    if (this.GetTableRelatedIsEmpty()) {
                        return null;
                    }
                    return (R)this.boxSessionImpl.a((Class)op.Value, op.TableName, op.Length == 1, op.Key);
                }
                case 2: {
                    boolean bl2;
                    String string = op.TableName;
                    boolean bl3 = string.charAt(0) == '*' || string.charAt(1) == '*';
                    boolean bl4 = bl2 = string.charAt(0) == '!' || string.charAt(1) == '!';
                    if (bl3 && bl2) {
                        string = new String(string.substring(2));
                    } else if (bl3 || bl2) {
                        string = new String(string.substring(1));
                    }
                    bh.b b2 = be.a(string, this.boxSessionImpl);
                    if (b2 == null) {
                        return null;
                    }
                    Class clazz = (Class)op.Value;
                    int n2 = 0;
                    if (bl3) {
                        n2 = this.boxSessionImpl.f().i().CachePageCount / 3 * 2;
                    }
                    bh.b b3 = be.a(clazz, b2, (Object[])op.Key);
                    dd dd2 = this.boxSessionImpl.a(b3, n2, bl2);
                    return (R)dk.a(dd2);
                }
                case 3: {
                    bh.b b4 = be.a(op.TableName, this.boxSessionImpl);
                    bh.b b5 = be.a(Object.class, b4, (Object[])op.Key);
                    dd dd3 = this.boxSessionImpl.a(b5, 0, false);
                    long l2 = 0L;
                    de de2 = dd3.a();
                    while (de2.a()) {
                        ++l2;
                    }
                    return (R)Long.valueOf(l2);
                }
                case 18: {
                    return (R)this.boxSessionImpl.a(op.TableName, (int)((Integer)op.Key), (String[])op.Value);
                }
                case 10: {
                    return (R)this.server.Execute(this, (byte[])op.Key);
                }
                case 4: {
                    return (R)Long.valueOf(this.boxSessionImpl.a((Short)op.Key, (Long)op.Value));
                }
                case 5: {
                    if (op.Key != null) {
                        x x2 = x.a((byte[][])op.Key);
                        return (R)this.boxSessionImpl.a(x2);
                    }
                    return (R)this.boxSessionImpl.i();
                }
                case 13: {
                    return (R)this.boxSessionImpl.a((Class)op.Value, bz.a((UUID)op.Key));
                }
            }
            return this.ActionWithKey(op);
        }

        private <R> R ActionWithKey(OPEntity op) {
            Comparable<UUID> comparable;
            k k2 = null;
            switch (op.ActionType.Ord) {
                case 14: {
                    if (op.Value == null) {
                        return null;
                    }
                    bz bz2 = this.boxSessionImpl.a(op.Value, op.Length, null);
                    comparable = bz2.b();
                    k2 = k.a(bz2, comparable);
                    break;
                }
                case 12: {
                    if (op.Value == null) {
                        return null;
                    }
                    bz bz3 = this.boxSessionImpl.a(bz.a((UUID)op.Key), op.Value);
                    comparable = bz3.b();
                    k2 = k.a(bz3, comparable);
                    break;
                }
                case 15: {
                    if (op.Value == null) {
                        return null;
                    }
                    dl<Object> dl2 = new dl<Object>((Object[])op.Value);
                    bz bz4 = this.boxSessionImpl.a(bz.a((UUID)op.Key), dl2);
                    comparable = bz4.b();
                    k2 = k.a(bz4, comparable);
                    break;
                }
                case 11: {
                    bz bz5 = this.boxSessionImpl.a(bz.a((UUID)op.Key));
                    comparable = bz5.b();
                    k2 = k.a(bz5, comparable);
                    break;
                }
                case 9: {
                    if (op.Value == null) {
                        return (R)Boolean.FALSE;
                    }
                    k2 = this.boxSessionImpl.a(op.TableName, op.Value, op.Length);
                    comparable = k2 != null;
                    break;
                }
                case 6: {
                    k2 = this.boxSessionImpl.a(op.TableName, op.Key);
                    comparable = k2 != null;
                    break;
                }
                case 7: {
                    if (op.Value == null) {
                        return (R)Boolean.FALSE;
                    }
                    k2 = this.boxSessionImpl.a(op.TableName, op.Key, op.Value, op.Length);
                    comparable = k2 != null;
                    break;
                }
                case 8: {
                    if (op.Value == null) {
                        return (R)Boolean.FALSE;
                    }
                    k2 = this.boxSessionImpl.a(op.TableName, op.Key, op.Value);
                    comparable = k2 != null;
                    break;
                }
                default: {
                    return (R)b.a();
                }
            }
            if (k2 != null) {
                if (this.boxSessionImpl.a()) {
                    op.Value = k2.b();
                    op.Key = k2.d();
                    op.Length = k2.b().d;
                    this.boxSessionImpl.b().a(op);
                }
                return (R)comparable;
            }
            return (R)comparable;
        }
    }

    public static class LocalDatabase
    extends Database {
        public String MSG_EX_EnsureIndex;
        private ar db;
        private LocalDatabaseServer server;

        protected LocalDatabase(LocalDatabaseServer localDataBaseServer, Object db2) {
            super(((ar)db2).b());
            this.db = (ar)db2;
            this.server = localDataBaseServer;
        }

        public IBoxRecycler getBoxRecycler() {
            return this.db.j();
        }

        @Override
        public LocalBox cube(long destAddress) {
            n n2 = this.db.a(Socket.Create(UUID.randomUUID(), 0L, destAddress));
            return new LocalBox(this.localAddress(), destAddress, this.server, n2);
        }

        @Override
        public void close() {
            if (this.server != null) {
                this.server.RemoveFromDataBases(this.db.b());
                this.db = (ar)bx.a(this.db);
                this.server = null;
            }
        }

        public Object gdb() {
            return this.db;
        }
    }
}

