/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer;

import iBoxDB.LocalServer.ActionType;
import iBoxDB.LocalServer.FileChannel;
import iBoxDB.bytecodes.ae;
import iBoxDB.bytecodes.an;
import iBoxDB.bytecodes.ck;
import iBoxDB.bytecodes.cq;
import iBoxDB.bytecodes.di;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;

public final class OPEntity
implements Serializable {
    private static final long serialVersionUID = 6158140506709651770L;
    public String TableName;
    public ActionType ActionType;
    public Object Key;
    public Object Value;
    public int Length;

    protected static <V> OPEntity makeInsert(String tableName, V value) {
        return OPEntity.makeInsert(tableName, value, -1);
    }

    protected static <V> OPEntity makeInsert(String tableName, V value, int reLength) {
        return OPEntity.CreateAction(tableName, iBoxDB.LocalServer.ActionType.Insert, null, value, reLength);
    }

    protected static <K, V> OPEntity makeUpdate(String tableName, K key, V value) {
        return OPEntity.makeUpdate(tableName, key, value, -1);
    }

    protected static <K, V> OPEntity makeUpdate(String tableName, K key, V value, int reLength) {
        return OPEntity.CreateAction(tableName, iBoxDB.LocalServer.ActionType.Update, key, value, reLength);
    }

    protected static <K, V> OPEntity makeUpdateNoIndex(String tableName, K key, V value) {
        return OPEntity.CreateAction(tableName, iBoxDB.LocalServer.ActionType.UpdateNoIndex, key, value);
    }

    protected static <K> OPEntity makeDelete(String tableName, K key) {
        return OPEntity.CreateAction(tableName, iBoxDB.LocalServer.ActionType.Delete, key, null);
    }

    protected static <K, V> OPEntity makeSelectByKey(String tableName, boolean keep, K key, Class<V> vClass) {
        int n2 = keep ? 1 : 0;
        return OPEntity.CreateAction(tableName, iBoxDB.LocalServer.ActionType.SelectByKey, key, vClass, n2);
    }

    protected static <V> OPEntity makePageInsert(V value) {
        return OPEntity.makePageInsert(value, -1);
    }

    protected static <V> OPEntity makePageInsert(V value, int reLength) {
        return OPEntity.CreateAction(null, iBoxDB.LocalServer.ActionType.PageInsert, null, value, reLength);
    }

    protected static <V> OPEntity makePageUpdate(UUID key, V value) {
        return OPEntity.CreateAction(null, iBoxDB.LocalServer.ActionType.PageUpdate, key, value);
    }

    protected static <V> OPEntity makePageUpdatePart(UUID key, FileChannel.AddressBlock[] value) {
        return OPEntity.CreateAction(null, iBoxDB.LocalServer.ActionType.PageUpdatePart, key, value);
    }

    protected static <V> OPEntity makePageSelect(UUID key, Class<V> vClass) {
        return OPEntity.CreateAction(null, iBoxDB.LocalServer.ActionType.PageSelect, key, vClass);
    }

    protected static OPEntity makePageDelete(UUID key) {
        return OPEntity.CreateAction(null, iBoxDB.LocalServer.ActionType.PageDelete, key, null);
    }

    protected static <K, V> OPEntity CreateAction(String tableName, ActionType actionType, K k2, V v2, int reLength) {
        return new OPEntity(tableName, actionType, k2, v2, reLength);
    }

    protected static <K, V> OPEntity CreateAction(String tableName, ActionType actionType, K k2, V v2) {
        return OPEntity.CreateAction(tableName, actionType, k2, v2, -1);
    }

    public OPEntity() {
    }

    public OPEntity(String tableName, ActionType actType, Object key, Object value, int length) {
        this.TableName = tableName;
        this.ActionType = actType;
        this.Key = key;
        this.Value = value;
        this.Length = length;
    }

    public HashMap<String, Object> select() {
        return this.select(HashMap.class);
    }

    public <T> T select(Class<T> tclass) {
        if (this.Value == null) {
            return null;
        }
        if (tclass == Object.class) {
            return (T)this.Key;
        }
        if (tclass == byte[].class) {
            return (T)((byte[])this.Value);
        }
        return OPEntity.ObjectConvert(tclass, (byte[])this.Value);
    }

    public static <T> T ObjectConvert(Class<T> tclass, byte[] buffer) {
        cq cq2 = new cq(buffer);
        return ae.a(tclass).a(cq2);
    }

    public static <T> OPEntity ObjectConvert(T object) {
        return OPEntity.ObjectConvert(object, null);
    }

    public static <T> OPEntity ObjectConvert(T object, Object cache) {
        OPEntity oPEntity = new OPEntity();
        if (object instanceof byte[]) {
            oPEntity.Value = object;
            oPEntity.Length = -1;
            return oPEntity;
        }
        cq cq2 = cache != null ? (cq)cache : ck.a();
        cq2.d(0);
        Object r2 = ae.a(object.getClass());
        r2.a(cq2, object);
        byte[] byArray = new byte[cq2.s()];
        di.a(cq2.q(), 0, byArray, 0, byArray.length);
        oPEntity.Value = byArray;
        oPEntity.Length = r2.a();
        return oPEntity;
    }

    public static byte[] ArrayConvert(Object[] values) {
        cq cq2 = ck.a();
        an.a(cq2, values);
        byte[] byArray = new byte[cq2.s()];
        di.a(cq2.q(), 0, byArray, 0, byArray.length);
        return byArray;
    }

    public static Object[] ArrayConvert(byte[] values) {
        cq cq2 = new cq(values);
        return (Object[])an.a(cq2);
    }
}

