/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer.Replication;

import iBoxDB.LocalServer.Box;
import iBoxDB.LocalServer.CommitResult;
import iBoxDB.LocalServer.Database;
import iBoxDB.LocalServer.LocalDatabaseServer;
import iBoxDB.LocalServer.OPEntity;
import iBoxDB.bytecodes.bx;
import iBoxDB.bytecodes.bz;
import iBoxDB.bytecodes.cq;
import iBoxDB.bytecodes.dl;
import iBoxDB.bytecodes.p;
import iBoxDB.bytecodes.x;
import java.io.Serializable;

public class BoxData
implements Serializable {
    private static final long serialVersionUID = 4332338717378718793L;
    private final byte[] data;
    dl<OPEntity> actions = null;

    public BoxData(byte[] data) {
        this.data = data;
    }

    public byte[] toBytes() {
        return this.data;
    }

    public Iterable<OPEntity> getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        byte[] byArray = this.data;
        x x2 = x.a(byArray, true);
        dl<OPEntity> dl2 = x2.h;
        if (dl2 == null) {
            dl2 = new dl();
        }
        for (OPEntity oPEntity : dl2) {
            switch (oPEntity.ActionType.Ord) {
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 14: {
                    p p2 = x2.g.c((bz)oPEntity.Value);
                    x.d d2 = (x.d)p2.a((cq)null);
                    oPEntity.Value = d2.a();
                    break;
                }
                case 6: 
                case 11: 
                case 15: {
                    oPEntity.Value = null;
                    break;
                }
                default: {
                    oPEntity.Value = null;
                }
            }
        }
        this.actions = dl2;
        return this.actions;
    }

    public CommitResult slaveReplicate(Database self) {
        return BoxData.slaveReplicate(self, this);
    }

    public CommitResult masterReplicate(Database self) {
        return BoxData.masterReplicate(self, this);
    }

    public static CommitResult masterReplicate(Database self, BoxData ... data) {
        return BoxData.masterReplicate(self, 0L, data);
    }

    public static CommitResult masterReplicate(Database self, long dest, BoxData ... data) {
        Box box;
        block10: {
            CommitResult commitResult;
            if (data == null || data.length < 1) {
                return CommitResult.OK;
            }
            box = null;
            try {
                BoxData[] boxDataArray = data;
                int n2 = data.length;
                int n3 = 0;
                while (n3 < n2) {
                    BoxData boxData = boxDataArray[n3];
                    dl dl2 = (dl)boxData.getActions();
                    if (dl2 != null && dl2.c() > 0) {
                        box = box == null ? self.cube(dest) : box;
                        for (OPEntity oPEntity : dl2) {
                            switch (oPEntity.ActionType.Ord) {
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    box.Action(oPEntity);
                                }
                            }
                        }
                    }
                    ++n3;
                }
                if (box == null) break block10;
                commitResult = box.commit();
            }
            catch (Throwable throwable) {
                box = (Box)bx.a(box);
                throw throwable;
            }
            box = (Box)bx.a(box);
            return commitResult;
        }
        CommitResult commitResult = CommitResult.OK;
        box = (Box)bx.a(box);
        return commitResult;
    }

    protected static byte[][] Convert(BoxData[] data) {
        byte[][] byArrayArray = new byte[data.length][];
        int n2 = 0;
        while (n2 < data.length) {
            byArrayArray[n2] = data[n2].toBytes();
            ++n2;
        }
        return byArrayArray;
    }

    public static CommitResult slaveReplicate(Database self, BoxData ... data) {
        if (data == null || data.length < 1) {
            return CommitResult.OK;
        }
        LocalDatabaseServer.LocalBox localBox = (LocalDatabaseServer.LocalBox)self.cube();
        try {
            CommitResult commitResult = localBox.commit(BoxData.Convert(data));
            return commitResult;
        }
        finally {
            localBox.close();
        }
    }
}

