/*
 * Decompiled with CFR 0.152.
 */
package iBoxDB.LocalServer.Replication;

import iBoxDB.LocalServer.DatabaseConfig;
import iBoxDB.LocalServer.Replication.BoxData;
import iBoxDB.LocalServer.Replication.Socket;
import iBoxDB.bytecodes.a;
import iBoxDB.bytecodes.ag;
import iBoxDB.bytecodes.ap;
import iBoxDB.bytecodes.b;
import iBoxDB.bytecodes.bz;
import iBoxDB.bytecodes.ck;
import iBoxDB.bytecodes.cq;
import iBoxDB.bytecodes.dl;
import iBoxDB.bytecodes.x;
import iBoxDB.bytecodes.y;
import iBoxDB.bytecodes.z;
import java.io.Closeable;
import java.util.UUID;

public class QBuffer
implements Closeable {
    private bz firstBlock;
    private bz lastBlock;
    private UUID lastGuid;
    private dl<FreedBlock> freedBlock;
    private cq cached;
    private y fLayer;
    private String name;
    static final long MaxLength = 0x7FFFFFFFFFFFFFF3L;
    private static final ag<Socket> socketSer = ap.a;

    public static String GetBufferName(String name) {
        return String.valueOf(name) + ".buf";
    }

    public QBuffer(String name, DatabaseConfig config) {
        this.name = name;
        this.fLayer = y.a(config, name, null);
        this.firstBlock = bz.a();
        this.lastBlock = bz.a();
        this.lastGuid = null;
        this.freedBlock = new dl();
        this.freedBlock.a(FreedBlock.Create(12L, 0x7FFFFFFFFFFFFFF3L));
        this.cached = ck.a(32);
        if (!this.fLayer.c()) {
            z z2 = this.fLayer.e();
            this.cached.d(0);
            this.cached.b(28);
            z2.a(0L, this.cached.q(), 0, 12);
            bz bz2 = this.firstBlock = this.cached.a();
            while (!bz2.c()) {
                this.lastBlock = bz2;
                this.Allocate(this.lastBlock);
                z2.a(this.lastBlock.c, this.cached.q(), 0, 16);
                this.cached.d(0);
                this.lastGuid = this.cached.g();
                this.cached.d(0);
                z2.a(this.lastBlock.c + (long)this.lastBlock.d - 12L, this.cached.q(), 0, 12);
                bz2 = this.cached.a();
            }
        }
    }

    private bz Allocate(int len) {
        int n2 = 0;
        while (n2 < this.freedBlock.c()) {
            FreedBlock freedBlock = this.freedBlock.a(n2);
            if (freedBlock.Length == (long)len) {
                this.freedBlock.b(n2);
                return bz.a(freedBlock.Address, (int)freedBlock.Length);
            }
            if (freedBlock.Length > (long)len) {
                bz bz2 = bz.a(freedBlock.Address, len);
                freedBlock.Address += (long)len;
                freedBlock.Length -= (long)len;
                this.freedBlock.a(n2, freedBlock);
                return bz2;
            }
            ++n2;
        }
        return (bz)b.a();
    }

    private void Allocate(bz lBlock) {
        int n2 = 0;
        while (n2 < this.freedBlock.c()) {
            FreedBlock freedBlock = this.freedBlock.a(n2);
            if (lBlock.c >= freedBlock.Address && lBlock.d() <= freedBlock.EndingAddress()) {
                FreedBlock freedBlock2 = FreedBlock.Create(freedBlock.Address, lBlock.c - freedBlock.Address);
                FreedBlock freedBlock3 = FreedBlock.Create(lBlock.e(), freedBlock.EndingAddress() - lBlock.d());
                if (freedBlock2.Length < 0L || freedBlock3.Length < 0L) {
                    b.a();
                }
                if (freedBlock3.Length > 0L) {
                    this.freedBlock.a(n2, freedBlock3);
                } else {
                    this.freedBlock.b(n2);
                }
                if (freedBlock2.Length > 0L) {
                    this.freedBlock.b(n2, freedBlock2);
                }
                return;
            }
            ++n2;
        }
        a.o.a("AC");
    }

    private void DeAllocate(bz lBlock) {
        int n2 = 0;
        while (n2 < this.freedBlock.c()) {
            FreedBlock freedBlock = this.freedBlock.a(n2);
            if (lBlock.e() == freedBlock.Address) {
                freedBlock.Address = lBlock.c;
                freedBlock.Length += (long)lBlock.d;
                this.freedBlock.a(n2, freedBlock);
                return;
            }
            if (freedBlock.SlideAddress() == lBlock.c) {
                freedBlock.Length += (long)lBlock.d;
                this.freedBlock.a(n2, freedBlock);
                FreedBlock freedBlock2 = this.freedBlock.a(n2 + 1);
                if (freedBlock.SlideAddress() == freedBlock2.Address) {
                    freedBlock2.Address = freedBlock.Address;
                    freedBlock2.Length += freedBlock.Length;
                    this.freedBlock.a(n2 + 1, freedBlock2);
                    this.freedBlock.b(n2);
                }
                return;
            }
            if (lBlock.e() < freedBlock.Address) {
                this.freedBlock.b(n2, FreedBlock.Create(lBlock.c, lBlock.d));
                return;
            }
            ++n2;
        }
        a.o.a("DA");
    }

    public String getName() {
        return this.name;
    }

    public synchronized void enqueue(Socket socket, BoxData outBox) {
        this.enqueue(new Data(socket, outBox.toBytes()));
    }

    public synchronized boolean enqueue(Data sbytes) {
        Socket socket = sbytes.Socket;
        byte[] byArray = sbytes.Item;
        if (byArray == null) {
            return false;
        }
        if (socket.ID.equals(this.lastGuid)) {
            return false;
        }
        if (byArray.length < 1) {
            return false;
        }
        this.lastGuid = socket.ID;
        int n2 = 32 + byArray.length + 12;
        bz bz2 = this.Allocate(n2);
        if (bz2.d != n2) {
            b.a();
        }
        x x2 = new x(Socket.Empty());
        this.cached.d(0);
        this.cached.a(bz2);
        socketSer.a(this.cached, socket);
        this.cached.a(byArray);
        this.cached.a(bz.a());
        if (!this.lastBlock.c()) {
            long l2 = this.lastBlock.c + (long)this.lastBlock.d - 12L;
            x2.a(this.cached, l2, 12, 0);
        }
        this.lastBlock = bz2;
        x2.a(this.cached, bz2.c, bz2.d, 12);
        if (this.firstBlock.c()) {
            this.firstBlock = bz2;
            x2.a(this.cached, 0L, 12, 0);
        }
        this.fLayer.a(x2);
        return true;
    }

    public synchronized Data peek() {
        if (this.firstBlock.c()) {
            return null;
        }
        this.cached.d(0);
        this.cached.b(this.firstBlock.d);
        this.fLayer.e().a(this.firstBlock.c, this.cached.q(), 0, this.firstBlock.d);
        Socket socket = socketSer.a(this.cached);
        byte[] byArray = new byte[this.firstBlock.d - 12 - 32];
        this.cached.a(byArray, 0, byArray.length);
        return new Data(socket, byArray);
    }

    public synchronized boolean dequeue() {
        if (this.firstBlock.c()) {
            return false;
        }
        this.DeAllocate(this.firstBlock);
        long l2 = this.firstBlock.c + (long)this.firstBlock.d - 12L;
        this.cached.d(0);
        this.fLayer.e().a(l2, this.cached.q(), 0, 12);
        this.firstBlock = this.cached.a();
        if (this.firstBlock.c()) {
            this.lastBlock = bz.a();
        }
        x x2 = new x(Socket.Empty());
        x2.a(this.cached, 0L, 12, 0);
        this.fLayer.a(x2);
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.cached != null) {
            if (this.firstBlock.c()) {
                if (this.freedBlock.c() != 1 || this.freedBlock.a((int)0).Length != 0x7FFFFFFFFFFFFFF3L || this.freedBlock.a((int)0).Address != 12L) {
                    b.a();
                }
                this.fLayer.a(true);
            } else {
                this.fLayer.a(false);
            }
            this.cached = null;
        }
    }

    public static class Data {
        public final Socket Socket;
        public final byte[] Item;

        public Data(Socket socket, byte[] item) {
            this.Socket = socket;
            this.Item = item;
        }

        public BoxData asBoxData() {
            return new BoxData(this.Item);
        }
    }

    static class FreedBlock {
        public long Address;
        public long Length;

        public static FreedBlock Create(long addr, long len) {
            return new FreedBlock(addr, len);
        }

        public FreedBlock(long addr, long len) {
            this.Address = addr;
            this.Length = len;
        }

        public long EndingAddress() {
            return this.Address + this.Length - 1L;
        }

        public long SlideAddress() {
            return this.Address + this.Length;
        }
    }
}

