/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import io.divide.client.Backend;
import io.divide.client.BackendObject;
import io.divide.client.BackendServices;
import io.divide.client.BackendUser;
import io.divide.client.Config;
import io.divide.client.auth.AccountStorage;
import io.divide.client.auth.AuthManager;
import io.divide.client.auth.credentials.XmlAccoutStorage;
import io.divide.client.cache.LocalStorageIBoxDb;
import io.divide.client.data.DataManager;
import io.divide.client.data.ObjectManager;
import io.divide.shared.file.Storage;
import io.divide.shared.file.XmlStorage;
import io.divide.shared.logging.Logger;
import io.divide.shared.server.DAO;
import java.io.File;
import java.util.Objects;

public class BackendModule<BackendType extends Backend, ConfigType extends Config<BackendType>>
extends AbstractModule {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private Class<?> authManagerClass = AuthManager.class;
    private Class<?> dataManagerClass = DataManager.class;
    private Class<?> objectManagerClass = ObjectManager.class;
    protected ConfigType config;
    protected Class<ConfigType> type;

    protected BackendModule() {
    }

    public void init(ConfigType config) {
        this.config = config;
        this.type = config.getClass();
    }

    protected final void configure() {
        this.logConfiguration();
        if (this.config == null) {
            throw new IllegalStateException("Config can not be null");
        }
        this.bind(this.type).toInstance(this.config);
        this.bind(Config.class).toInstance(this.config);
        this.bind(Backend.class).in(Singleton.class);
        this.bind(Storage.class).toInstance((Object)new XmlStorage(new File(((Config)this.config).fileSavePath + "storage.xml"), 2));
        this.bind(AccountStorage.class).toInstance((Object)new XmlAccoutStorage(new File(((Config)this.config).fileSavePath + "accounts.xml")));
        this.bind((TypeLiteral)new TypeLiteral<DAO<BackendObject, BackendObject>>(){}).to((TypeLiteral)new TypeLiteral<LocalStorageIBoxDb<BackendObject, BackendObject>>(){}).in(Singleton.class);
        if (AuthManager.class.equals(this.getAuthManagerClass())) {
            this.bind(AuthManager.class).in(Singleton.class);
        } else {
            this.bind(AuthManager.class).to(this.getAuthManagerClass()).in(Singleton.class);
        }
        if (DataManager.class.equals(this.getDataManagerClass())) {
            this.bind(DataManager.class).in(Singleton.class);
        } else {
            this.bind(DataManager.class).to(this.getDataManagerClass()).in(Singleton.class);
        }
        if (ObjectManager.class.equals(this.getObjectManagerClass())) {
            this.bind(ObjectManager.class).in(Singleton.class);
        } else {
            this.bind(ObjectManager.class).to(this.getObjectManagerClass()).in(Singleton.class);
        }
        this.requestStaticInjection(new Class[]{Backend.class});
        this.requestStaticInjection(new Class[]{BackendUser.class});
        this.requestStaticInjection(new Class[]{BackendServices.class});
        this.additionalConfig(this.config);
    }

    protected void additionalConfig(ConfigType config) {
    }

    public Class<AuthManager> getAuthManagerClass() {
        return this.authManagerClass;
    }

    public <A extends AuthManager> void setAuthManagerClass(Class<A> authManagerClass) {
        this.authManagerClass = authManagerClass;
    }

    public Class<DataManager> getDataManagerClass() {
        return this.dataManagerClass;
    }

    public <D extends DataManager> void setDataManagerClass(Class<D> dataManagerClass) {
        this.dataManagerClass = dataManagerClass;
    }

    public Class<ObjectManager> getObjectManagerClass() {
        return this.objectManagerClass;
    }

    public <O extends ObjectManager> void setObjectManagerClass(Class<O> objectManagerClass) {
        this.objectManagerClass = objectManagerClass;
    }

    private void Log(Objects o2) {
        System.out.println("Config: " + o2);
    }

    private void logConfiguration() {
        this.logger.debug((Object)"Module Configuration");
        this.logger.debug((Object)("Binding: " + this.type + " to " + this.config.getClass()));
        this.logger.debug((Object)("Binding: " + Config.class + " to " + this.config.getClass()));
        this.logger.debug((Object)("Binding: " + Backend.class + " in " + Singleton.class));
        this.logger.debug((Object)("Binding: " + Storage.class + " to " + XmlStorage.class + " by " + ((Config)this.config).fileSavePath + "storage.xml"));
        this.logger.debug((Object)("Binding: " + AccountStorage.class + " to " + XmlAccoutStorage.class + " by " + ((Config)this.config).fileSavePath + "accounts.xml"));
        this.logger.debug((Object)("Binding: " + AuthManager.class + " to " + XmlAccoutStorage.class + " by " + ((Config)this.config).fileSavePath + "accounts.xml"));
        this.logger.debug((Object)("Binding: " + DataManager.class + " to " + XmlAccoutStorage.class + " by " + ((Config)this.config).fileSavePath + "accounts.xml"));
        this.logger.debug((Object)("Binding: " + ObjectManager.class + " to " + XmlAccoutStorage.class + " by " + ((Config)this.config).fileSavePath + "accounts.xml"));
        this.logger.debug((Object)("Binding: " + AuthManager.class + " to " + this.getAuthManagerClass()));
        this.logger.debug((Object)("Binding: " + DataManager.class + " to " + this.getDataManagerClass()));
        this.logger.debug((Object)("Binding: " + ObjectManager.class + " to " + this.getObjectManagerClass()));
    }
}

