/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client;

import com.google.inject.Inject;
import io.divide.client.auth.AuthManager;
import io.divide.client.auth.SignInResponse;
import io.divide.client.auth.SignUpResponse;
import io.divide.client.auth.credentials.LocalCredentials;
import io.divide.client.auth.credentials.LoginCredentials;
import io.divide.client.auth.credentials.SignUpCredentials;
import io.divide.client.auth.credentials.ValidCredentials;
import io.divide.shared.logging.Logger;
import io.divide.shared.transitory.Credentials;
import rx.Observable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public final class BackendUser
extends Credentials {
    private static Logger logger = Logger.getLogger(BackendUser.class);
    @Inject
    private static AuthManager authManager;
    private static final String ANONYMOUS_KEY = "anonymous_key";

    public BackendUser() {
    }

    public BackendUser(String username, String email, String password) {
        this();
        this.setUsername(username);
        this.setEmailAddress(email);
        this.setPassword(password);
    }

    private static AuthManager getAM() {
        if (authManager == null) {
            throw new RuntimeException("Backend not initialized!");
        }
        return authManager;
    }

    public static BackendUser from(ValidCredentials credentials) {
        BackendUser beu = new BackendUser();
        beu.initFrom(credentials);
        return beu;
    }

    public static BackendUser getUser() {
        return BackendUser.getAM().getUser();
    }

    public static LocalCredentials getStoredAccount() {
        return authManager.getStoredAccount();
    }

    protected final boolean isSystemUser() {
        return false;
    }

    private void initFrom(Credentials credentials) {
        logger.debug((Object)("initFrom: " + credentials));
        try {
            this.meta_data = credentials.getMetaData();
            this.user_data = credentials.getUserData();
        }
        catch (Exception e2) {
            logger.error((Object)"Failed to init BackendUser from Credentials", (Throwable)e2);
        }
    }

    public static BackendUser fromToken(String token) {
        return (BackendUser)((Object)BackendUser.getAM().getUserFromAuthToken(token).toBlockingObservable().first());
    }

    public static SignInResponse signIn(LoginCredentials loginCredentials) {
        return BackendUser.getAM().login(loginCredentials);
    }

    public static SignInResponse signIn(String email, String password) {
        return BackendUser.signIn(new LoginCredentials(email, password));
    }

    public static SignUpResponse signUp(SignUpCredentials signUpCredentials) {
        return BackendUser.getAM().signUp(signUpCredentials);
    }

    public static SignUpResponse signUp(String username, String email, String password) {
        return BackendUser.signUp(new SignUpCredentials(username, email, password));
    }

    public static Observable<BackendUser> signInInBackground(String email, String password) {
        return BackendUser.getAM().loginASync(new LoginCredentials(email, password));
    }

    public static Observable<BackendUser> signUpInBackground(String username, String email, String password) {
        return BackendUser.getAM().signUpASync(new SignUpCredentials(username, email, password));
    }

    public static void logout() {
        BackendUser.getAM().logout();
    }

    public void requestPasswordReset(String email) {
        throw new NotImplementedException();
    }

    public Observable<Boolean> requestPasswordResetInBackground(String email) {
        throw new NotImplementedException();
    }

    public boolean signUp() {
        SignUpCredentials creds = new SignUpCredentials(this.getUsername(), this.getEmailAddress(), this.getPassword());
        SignUpResponse response = BackendUser.getAM().signUp(creds);
        if (response.getStatus().isSuccess()) {
            this.initFrom((Credentials)response.get());
            return true;
        }
        return false;
    }

    private void save(BackendUser user) {
        BackendUser.getAM().sendUserData(user).subscribe();
    }

    private Observable<Void> saveASync(BackendUser user) {
        return BackendUser.getAM().sendUserData(user);
    }

    public void save() {
        this.save(this);
    }

    public Observable<Void> saveASync() {
        return this.saveASync(this);
    }

    public String toString() {
        return "BackendUser{emailAddress='" + this.getEmailAddress() + '\'' + ", password='" + this.getPassword() + '\'' + ", userKey='" + this.getOwnerId() + '\'' + ", authToken='" + this.getAuthToken() + '\'' + ", createDate=" + this.getCreateDate() + ", validation='" + this.getValidation() + '\'' + '}';
    }
}

