/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client;

import com.squareup.okhttp.OkHttpClient;
import io.divide.client.Backend;
import io.divide.client.BackendModule;
import java.lang.reflect.InvocationTargetException;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public abstract class Config<BackendType extends Backend> {
    public String fileSavePath;
    public String serverUrl;
    public final long id = System.currentTimeMillis();
    public final OkHttpClient client = new OkHttpClient();
    private Scheduler subscribeOn = Schedulers.io();
    private Scheduler observeOn = Schedulers.io();
    private BackendModule backendModule;

    public abstract Class<BackendType> getModuleType();

    public Config(String fileSavePath, String url) {
        this(fileSavePath, url, BackendModule.class);
    }

    protected <ModuleType extends BackendModule> Config(String fileSavePath, String url, Class<ModuleType> moduleClass) {
        this.fileSavePath = fileSavePath;
        this.serverUrl = url;
        this.setModule(moduleClass);
    }

    public Config observeOn(Scheduler observeOn) {
        this.observeOn = observeOn;
        return this;
    }

    public Config subscribeOn(Scheduler subscribeOn) {
        this.subscribeOn = subscribeOn;
        return this;
    }

    public Scheduler observeOn() {
        return this.observeOn;
    }

    public Scheduler subscribeOn() {
        return this.subscribeOn;
    }

    public final BackendModule getModule() {
        return this.backendModule;
    }

    public final <ModuleType extends BackendModule> void setModule(Class<ModuleType> moduleClass) {
        try {
            this.backendModule = Config.createInstance(moduleClass, this);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new IllegalArgumentException(e2);
        }
    }

    private static <B extends BackendModule, C extends Backend> B createInstance(Class<B> type, Config<C> config) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        BackendModule b2 = (BackendModule)((Object)type.newInstance());
        b2.init(config);
        return (B)((Object)b2);
    }

    public String toString() {
        return "Config{fileSavePath='" + this.fileSavePath + '\'' + ", serverUrl='" + this.serverUrl + '\'' + ", id=" + this.id + ", client=" + this.client + ", subscribeOn=" + this.subscribeOn + ", observeOn=" + this.observeOn + ", backendModule=" + (Object)((Object)this.backendModule) + '}';
    }
}

