/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.auth.credentials;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.divide.client.auth.AccountStorage;
import io.divide.client.auth.credentials.LocalCredentials;
import io.divide.shared.file.XmlStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XmlAccoutStorage
implements AccountStorage {
    Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
    XmlStorage storage;

    public XmlAccoutStorage(File file) {
        this.storage = new XmlStorage(file, 2);
    }

    @Override
    public void addAcccount(LocalCredentials credentials) {
        this.storage.edit().putString(credentials.getName(), this.gson.toJson((Object)credentials)).commit();
    }

    @Override
    public void removeAccount(String accountName) {
        this.storage.edit().remove(accountName).commit();
    }

    @Override
    public LocalCredentials getAccount(String accountName) {
        if (this.storage.contains(accountName)) {
            return (LocalCredentials)this.gson.fromJson(this.storage.getString(accountName, null), LocalCredentials.class);
        }
        return null;
    }

    @Override
    public boolean isAuthenticated(String accountName) {
        return false;
    }

    @Override
    public void setAuthToken(String accountName, String token) {
        LocalCredentials credentials = this.getAccount(accountName);
        if (credentials != null) {
            credentials.setAuthToken(token);
            this.addAcccount(credentials);
        }
    }

    @Override
    public void setRecoveryToken(String accountName, String token) {
        LocalCredentials credentials = this.getAccount(accountName);
        if (credentials != null) {
            credentials.setRecoveryToken(token);
            this.addAcccount(credentials);
        }
    }

    @Override
    public List<LocalCredentials> getAccounts() {
        Map map = this.storage.getAll();
        ArrayList<LocalCredentials> list = new ArrayList<LocalCredentials>(map.size());
        for (String s2 : map.values()) {
            list.add((LocalCredentials)this.gson.fromJson(s2, LocalCredentials.class));
        }
        return list;
    }

    @Override
    public boolean exists(String name) {
        return this.storage.contains(name);
    }
}

