/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.data;

import com.google.gson.Gson;
import com.google.inject.Inject;
import io.divide.client.BackendObject;
import io.divide.client.Config;
import io.divide.client.auth.AuthManager;
import io.divide.client.data.DataWebService;
import io.divide.client.web.AbstractWebManager;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.util.IOUtils;
import io.divide.shared.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import retrofit.client.Response;
import rx.Observable;
import rx.Subscriber;

public class DataManager
extends AbstractWebManager<DataWebService> {
    @Inject
    private AuthManager authManager;
    private static Gson gson = new Gson();

    @Inject
    public DataManager(Config config) {
        super(config);
    }

    @Override
    protected Class<DataWebService> getType() {
        return DataWebService.class;
    }

    public <B extends BackendObject> Observable<Void> send(Collection<B> objects) {
        return ((DataWebService)this.getWebService()).save(this.isLoggedIn(), objects).subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    public <B extends BackendObject> Observable<Collection<B>> get(final Class<B> type, final Collection<String> objects) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Collection<B>>(){

            public void call(Subscriber<? super Collection<B>> observer) {
                try {
                    observer.onNext((Object)DataManager.this.convertRequest(DataManager.this.getArrayType(type), ((DataWebService)DataManager.this.getWebService()).get(DataManager.this.isLoggedIn(), Query.safeTable((Class)type), objects)));
                    observer.onCompleted();
                }
                catch (Exception e2) {
                    observer.onError((Throwable)e2);
                }
            }
        }).subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    public <B extends BackendObject> Observable<Collection<B>> query(final Class<B> type, final Query query) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Collection<B>>(){

            public void call(Subscriber<? super Collection<B>> observer) {
                try {
                    observer.onNext((Object)DataManager.this.convertRequest(DataManager.this.getArrayType(type), ((DataWebService)DataManager.this.getWebService()).query(DataManager.this.isLoggedIn(), query)));
                    observer.onCompleted();
                }
                catch (Exception e2) {
                    observer.onError((Throwable)e2);
                }
            }
        }).subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    public <B extends BackendObject> Observable<Integer> count(Class<B> type) {
        return ((DataWebService)this.getWebService()).count(this.isLoggedIn(), Query.safeTable(type)).subscribeOn(this.config.subscribeOn()).observeOn(this.config.observeOn());
    }

    private String isLoggedIn() throws RuntimeException {
        if (this.authManager != null && this.authManager.getUser() != null && this.authManager.getUser().getAuthToken() != null) {
            return "CUSTOM " + this.authManager.getUser().getAuthToken();
        }
        throw new RuntimeException("User state error.");
    }

    private <B extends TransientObject> Collection<B> convertRequest(Class<B[]> type, Response response) {
        String body = null;
        try {
            body = IOUtils.toString((InputStream)response.getBody().in());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Object[] t2 = (TransientObject[])gson.fromJson(body, type);
        return ObjectUtils.v2c((Object[])t2);
    }

    private <T extends TransientObject> Class<T[]> getArrayType(Class<T> type) {
        return Array.newInstance(type, 0).getClass();
    }
}

