/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.data;

import com.google.inject.Inject;
import io.divide.client.BackendObject;
import io.divide.client.BackendUser;
import io.divide.client.data.DataManager;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.transitory.query.SelectOperation;
import java.util.Arrays;
import java.util.Collection;
import rx.Observable;

public class ObjectManager {
    @Inject
    DataManager dataManager;
    @Inject
    DAO<BackendObject, BackendObject> localStorage;
    private RemoteStorage remote = new RemoteStorage();

    public DAO<BackendObject, BackendObject> local() {
        return this.localStorage;
    }

    public RemoteStorage remote() {
        return this.remote;
    }

    public static class NotLoggedInException
    extends Exception {
    }

    public class RemoteStorage {
        private RemoteStorage() {
        }

        private <B extends BackendObject> Collection<B> assignUser(BackendUser user, B ... objects) throws NotLoggedInException {
            return this.assignUser(user, (Collection<B>)Arrays.asList(objects));
        }

        private <B extends BackendObject> Collection<B> assignUser(BackendUser user, Collection<B> objects) throws NotLoggedInException {
            for (BackendObject o2 : objects) {
                if (o2.getOwnerId() != null) continue;
                o2.setOwnerId(user.getOwnerId());
            }
            return objects;
        }

        public <B extends BackendObject> Observable<Void> save(B ... objects) {
            try {
                BackendUser user = BackendUser.getUser();
                if (user == null) {
                    throw new NotLoggedInException();
                }
                return ObjectManager.this.dataManager.send(this.assignUser(user, (BackendObject[])objects));
            }
            catch (Exception e2) {
                return Observable.error((Throwable)e2);
            }
        }

        public <B extends BackendObject> Observable<Collection<B>> load(Class<B> type, String ... keys) {
            return ObjectManager.this.dataManager.get(type, Arrays.asList(keys));
        }

        public <B extends BackendObject> Observable<Collection<B>> query(Class<B> type, Query query) {
            SelectOperation so;
            if (query.getSelect() != null && !(so = query.getSelect()).getType().equals(type)) {
                throw new IllegalStateException(so.getErrorMessage());
            }
            if (!query.getFrom().equals(Query.safeTable(type))) {
                throw new IllegalStateException("Can not return a different type then what is queried!\nExpected: " + query.getFrom() + "\n" + "Actual: " + Query.safeTable(type));
            }
            return ObjectManager.this.dataManager.query(type, query);
        }

        public <B extends BackendObject> Observable<Integer> count(Class<B> type) {
            return ObjectManager.this.dataManager.count(type);
        }
    }
}

