/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC2")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="AMIES")
public class AvoidMultipleIfElseStatement
extends IssuableSubscriptionVisitor {
    protected static final String RULE_MESSAGE = "Using a switch statement instead of multiple if-else if possible";

    private void checkIfStatement(Tree tree) {
        int sizeBody = 0;
        int countIfStatement = 0;
        Tree parentNode = tree.parent();
        if (!(parentNode instanceof BlockTree)) {
            return;
        }
        BlockTree node = (BlockTree)parentNode;
        sizeBody = node.body().toArray().length;
        for (int idx = 0; idx < sizeBody; ++idx) {
            if (!(node.body().get(idx) instanceof IfStatementTree)) continue;
            ++countIfStatement;
        }
        if (countIfStatement > 1) {
            this.reportIssue(tree, RULE_MESSAGE);
        }
    }

    private void checkElseIfStatement(Tree tree) {
        IfStatementTree node = (IfStatementTree)tree;
        int count = 0;
        while (true) {
            StatementTree statementTree;
            if (count >= 2) {
                this.reportIssue(tree, RULE_MESSAGE);
            }
            if (!((statementTree = node.elseStatement()) instanceof IfStatementTree)) break;
            ++count;
            node = (IfStatementTree)statementTree;
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        this.checkIfStatement(tree);
        this.checkElseIfStatement(tree);
    }
}

