/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC1")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="GRC1")
public class AvoidSpringRepositoryCallInLoopCheck
extends IssuableSubscriptionVisitor {
    protected static final String RULE_MESSAGE = "Avoid Spring repository call in loop";
    private static final String SPRING_REPOSITORY = "org.springframework.data.repository.Repository";
    private static final MethodMatchers REPOSITORY_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.data.repository.Repository"}).anyName().withAnyParameters().build();
    private final AvoidSpringRepositoryCallInLoopCheckVisitor visitorInFile = new AvoidSpringRepositoryCallInLoopCheckVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT);
    }

    public void visitNode(Tree tree) {
        tree.accept((TreeVisitor)this.visitorInFile);
    }

    private class AvoidSpringRepositoryCallInLoopCheckVisitor
    extends BaseTreeVisitor {
        private AvoidSpringRepositoryCallInLoopCheckVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (REPOSITORY_METHOD.matches(tree)) {
                AvoidSpringRepositoryCallInLoopCheck.this.reportIssue((Tree)tree, AvoidSpringRepositoryCallInLoopCheck.RULE_MESSAGE);
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

