/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.VisibleForTesting;
import org.sonarsource.analyzer.commons.collections.MapEntriesIterable;
import org.sonarsource.analyzer.commons.collections.PMap;
import org.sonarsource.analyzer.commons.collections.PSet;
import org.sonarsource.analyzer.commons.collections.TreeIterator;

@Debug.Renderer(childrenArray="toArray()", hasChildren="toArray().isEmpty()")
abstract class AVLTree<K, V>
implements PMap<K, V>,
PSet<K> {
    private static final AVLTree EMPTY = new AVLTree(){

        @Override
        protected AVLTree left() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AVLTree right() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AVLTree nextInBucket() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object key() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int height() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof AVLTree && ((AVLTree)obj).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    AVLTree() {
    }

    public static <K, V> AVLTree<K, V> create() {
        return EMPTY;
    }

    public AVLTree<K, V> add(K e) {
        return AVLTree.put(e, e, this);
    }

    @Override
    public boolean contains(K k) {
        return this.get(k) != null;
    }

    @Override
    public AVLTree<K, V> put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return AVLTree.put(key, value, this);
    }

    @Override
    public AVLTree<K, V> remove(K key) {
        Objects.requireNonNull(key);
        return AVLTree.remove(key, this);
    }

    @Override
    @Nullable
    public V get(K key) {
        Objects.requireNonNull(key);
        int h = key.hashCode();
        AVLTree t = this;
        while (!t.isEmpty()) {
            int c = t.key().hashCode();
            if (h == c) {
                return (V)((t = AVLTree.searchInBucket(key, t)) == null ? null : t.value());
            }
            if (h < c) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return null;
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        this.forEach(this, action);
    }

    private void forEach(AVLTree t, Consumer<? super K> action) {
        if (t.isEmpty()) {
            return;
        }
        this.forEach(t.left(), action);
        this.forEach(t.right(), action);
        while (t != null) {
            action.accept(t.key());
            t = t.nextInBucket();
        }
    }

    @Override
    public void forEach(BiConsumer<K, V> consumer) {
        this.forEach(this, consumer);
    }

    private void forEach(AVLTree t, BiConsumer<K, V> action) {
        if (t.isEmpty()) {
            return;
        }
        this.forEach(t.left(), action);
        this.forEach(t.right(), action);
        while (t != null) {
            action.accept(t.key(), t.value());
            t = t.nextInBucket();
        }
    }

    @VisibleForTesting
    Object[] toArray() {
        ArrayList<NodeRenderer> nodes = new ArrayList<NodeRenderer>();
        this.forEach((K k, V v) -> nodes.add(new NodeRenderer<Object, Object>(k, v)));
        if (nodes.stream().map(kvNodeRenderer -> kvNodeRenderer.key).allMatch(Comparable.class::isInstance)) {
            nodes.sort(Comparator.comparing(kvNodeRenderer -> (Comparable)kvNodeRenderer.key));
        }
        return nodes.toArray();
    }

    @Override
    public Iterator<K> iterator() {
        return new TreeKeyIterator(this);
    }

    @Override
    public Iterable<Map.Entry<K, V>> entries() {
        return new MapEntriesIterable(this);
    }

    protected abstract AVLTree left();

    protected abstract AVLTree right();

    @Nullable
    protected abstract AVLTree nextInBucket();

    protected abstract Object key();

    protected abstract Object value();

    protected abstract int height();

    private static AVLTree put(Object key, Object value, AVLTree t) {
        int c;
        if (t.isEmpty()) {
            return AVLTree.createNode(t, key, value, null, t);
        }
        int h = key.hashCode();
        if (h == (c = t.key().hashCode())) {
            AVLTree nextInBucket = t.nextInBucket();
            if (key.equals(t.key())) {
                if (value.equals(t.value())) {
                    return t;
                }
                return AVLTree.createNode(t.left(), key, value, nextInBucket, t.right());
            }
            AVLTree nodeToReplace = AVLTree.searchInBucket(key, nextInBucket);
            if (nodeToReplace != null && value.equals(nodeToReplace.value())) {
                return t;
            }
            return AVLTree.createNode(t.left(), key, value, AVLTree.createBucket(t.key(), t.value(), AVLTree.removeFromBucket(nextInBucket, nodeToReplace)), t.right());
        }
        if (h < c) {
            AVLTree left = AVLTree.put(key, value, t.left());
            if (left == t.left()) {
                return t;
            }
            return AVLTree.balance(left, t, t.right());
        }
        AVLTree right = AVLTree.put(key, value, t.right());
        if (right == t.right()) {
            return t;
        }
        return AVLTree.balance(t.left(), t, right);
    }

    private static AVLTree remove(Object key, AVLTree t) {
        int c;
        if (t.isEmpty()) {
            return t;
        }
        int h = key.hashCode();
        if (h == (c = t.key().hashCode())) {
            AVLTree nextInBucket = t.nextInBucket();
            if (key.equals(t.key())) {
                if (nextInBucket != null) {
                    return AVLTree.createNode(t.left(), nextInBucket.key(), nextInBucket.value(), nextInBucket.nextInBucket(), t.right());
                }
                return AVLTree.combineTrees(t.left(), t.right());
            }
            AVLTree nodeToRemove = AVLTree.searchInBucket(key, nextInBucket);
            if (nodeToRemove == null) {
                return t;
            }
            return AVLTree.createNode(t.left(), t.key(), t.value(), AVLTree.removeFromBucket(nextInBucket, nodeToRemove), t.right());
        }
        if (h < c) {
            AVLTree left = AVLTree.remove(key, t.left());
            if (left == t.left()) {
                return t;
            }
            return AVLTree.balance(left, t, t.right());
        }
        AVLTree right = AVLTree.remove(key, t.right());
        if (right == t.right()) {
            return t;
        }
        return AVLTree.balance(t.left(), t, right);
    }

    private static AVLTree combineTrees(AVLTree l, AVLTree r) {
        if (l.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return l;
        }
        NodeRef oldNode = new NodeRef();
        AVLTree newRight = AVLTree.removeMinBinding(r, oldNode);
        return AVLTree.balance(l, oldNode.node, newRight);
    }

    private static AVLTree removeMinBinding(AVLTree t, NodeRef noderemoved) {
        assert (!t.isEmpty());
        if (t.left().isEmpty()) {
            noderemoved.node = t;
            return t.right();
        }
        return AVLTree.balance(AVLTree.removeMinBinding(t.left(), noderemoved), t, t.right());
    }

    private static AVLTree balance(AVLTree l, AVLTree oldNode, AVLTree r) {
        if (l.height() > r.height() + 2) {
            assert (!l.isEmpty());
            AVLTree ll = l.left();
            AVLTree lr = l.right();
            if (ll.height() >= lr.height()) {
                return AVLTree.createNode(ll, l, AVLTree.createNode(lr, oldNode, r));
            }
            assert (!lr.isEmpty());
            AVLTree lrl = lr.left();
            AVLTree lrr = lr.right();
            return AVLTree.createNode(AVLTree.createNode(ll, l, lrl), lr, AVLTree.createNode(lrr, oldNode, r));
        }
        if (r.height() > l.height() + 2) {
            assert (!r.isEmpty());
            AVLTree rl = r.left();
            AVLTree rr = r.right();
            if (rr.height() >= rl.height()) {
                return AVLTree.createNode(AVLTree.createNode(l, oldNode, rl), r, rr);
            }
            assert (!rl.isEmpty());
            AVLTree rll = rl.left();
            AVLTree rlr = rl.right();
            return AVLTree.createNode(AVLTree.createNode(l, oldNode, rll), rl, AVLTree.createNode(rlr, r, rr));
        }
        return AVLTree.createNode(l, oldNode, r);
    }

    private static AVLTree createNode(AVLTree newLeft, AVLTree oldTree, AVLTree newRight) {
        return new Node(newLeft, newRight, oldTree.key(), oldTree.value(), oldTree.nextInBucket(), AVLTree.incrementHeight(newLeft, newRight));
    }

    private static Node createNode(AVLTree l, Object key, Object value, @Nullable AVLTree nextInBucket, AVLTree r) {
        return new Node(l, r, key, value, nextInBucket, AVLTree.incrementHeight(l, r));
    }

    private static int incrementHeight(AVLTree l, AVLTree r) {
        return (l.height() > r.height() ? l.height() : r.height()) + 1;
    }

    @Nullable
    private static AVLTree searchInBucket(Object key, @Nullable AVLTree bucketStart) {
        for (AVLTree n = bucketStart; n != null; n = n.nextInBucket()) {
            if (!key.equals(n.key())) continue;
            return n;
        }
        return null;
    }

    @Nullable
    private static AVLTree removeFromBucket(@Nullable AVLTree bucketStart, @Nullable AVLTree nodeToRemove) {
        Node result = null;
        for (AVLTree c = bucketStart; c != null; c = c.nextInBucket()) {
            if (c == nodeToRemove) continue;
            result = AVLTree.createBucket(c.key(), c.value(), result);
        }
        return result;
    }

    private static Node createBucket(Object key, Object value, @Nullable AVLTree bucket) {
        return new Node(EMPTY, EMPTY, key, value, bucket, 0);
    }

    private static class Equals
    implements BiConsumer {
        private final AVLTree tree;
        private int sizeDifference;

        public static boolean compute(AVLTree first, AVLTree second) {
            Equals state = new Equals(first);
            if (!state.supersetOf(second)) {
                return false;
            }
            first.forEach(state);
            return state.sizeDifference == 0;
        }

        private Equals(AVLTree tree) {
            this.tree = tree;
        }

        private boolean supersetOf(@Nullable AVLTree node) {
            if (node == null || node.isEmpty()) {
                return true;
            }
            ++this.sizeDifference;
            return Objects.equals(node.value(), this.tree.get(node.key())) && this.supersetOf(node.nextInBucket()) && this.supersetOf(node.left()) && this.supersetOf(node.right());
        }

        public void accept(Object key, Object value) {
            --this.sizeDifference;
        }
    }

    static class Node
    extends AVLTree {
        private final AVLTree left;
        private final AVLTree right;
        private final int height;
        private final Object key;
        private final Object value;
        @Nullable
        private final AVLTree nextInBucket;
        private int hashCode;

        public Node(AVLTree left, AVLTree right, Object key, Object value, @Nullable AVLTree nextInBucket, int height) {
            this.left = left;
            this.right = right;
            this.key = key;
            this.value = value;
            this.nextInBucket = nextInBucket;
            this.height = height;
        }

        @Override
        protected AVLTree left() {
            return this.left;
        }

        @Override
        protected AVLTree right() {
            return this.right;
        }

        @Override
        protected AVLTree nextInBucket() {
            return this.nextInBucket;
        }

        @Override
        protected Object key() {
            return this.key;
        }

        @Override
        protected Object value() {
            return this.value;
        }

        @Override
        protected int height() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.left.hashCode() + (31 * this.key.hashCode() ^ this.value.hashCode()) + this.right.hashCode() + (this.nextInBucket == null ? 0 : this.nextInBucket.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Node) {
                Node other = (Node)obj;
                return this.hashCode() == other.hashCode() && Equals.compute(this, other);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.left.toString() + " " + this.key + "->" + this.value + (this.nextInBucket == null ? "" : this.nextInBucket.toString()) + this.right.toString();
        }
    }

    private static class NodeRef {
        AVLTree node;

        private NodeRef() {
        }
    }

    private static class TreeKeyIterator<E>
    implements Iterator<E> {
        private final TreeIterator<E, ?> treeIterator;

        TreeKeyIterator(AVLTree<E, ?> root) {
            this.treeIterator = new TreeIterator(root);
        }

        @Override
        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((AVLTree)this.treeIterator.next()).key();
        }
    }

    private static class NodeRenderer<K, V> {
        final K key;
        final V value;

        public NodeRenderer(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

