/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import io.github.ferhas.excel_models.ExcelUtils;
import io.github.ferhas.excel_models.annotation.ExcelColumn;
import io.github.ferhas.excel_models.annotation.ExcelObject;
import io.github.ferhas.excel_models.config.ExcelWriterConfig;
import io.github.ferhas.excel_models.exception.ExcelModelException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelWriter {
    private final ExcelWriterConfig config;
    private CellStyle contentStyle;

    public ExcelWriter() {
        this(new ExcelWriterConfig());
    }

    public ExcelWriter(ExcelWriterConfig config) {
        this.config = config;
    }

    public <T> OutputStream write(@NonNull Collection<T> models) {
        if (models == null) {
            throw new NullPointerException("models is marked non-null but is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(models, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public <T> void write(@NonNull Collection<T> models, @NonNull OutputStream outputStream) {
        if (models == null) {
            throw new NullPointerException("models is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (models.isEmpty()) {
            return;
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet;
            Map<Annotation, Field> fieldMap = ExcelUtils.getFieldMap(Class.forName(models.iterator().next().getClass().getTypeName()), true);
            if (this.config.getContentStyleBuilder() != null) {
                this.contentStyle = this.config.getContentStyleBuilder().apply((Workbook)workbook);
            } else {
                this.contentStyle = workbook.createCellStyle();
                this.contentStyle.setWrapText(true);
            }
            Sheet sheet2 = sheet = this.config.getSheetName() != null ? workbook.createSheet(this.config.getSheetName()) : workbook.createSheet();
            if (this.config.getHeaderBuilder() != null) {
                this.config.getHeaderBuilder().accept((Workbook)workbook, sheet);
            } else {
                CellStyle cellStyle = this.config.getHeaderStyleBuilder() != null ? this.config.getHeaderStyleBuilder().apply((Workbook)workbook) : null;
                Row headerRow = sheet.createRow(sheet.getPhysicalNumberOfRows());
                this.writeHeader(fieldMap, headerRow, cellStyle, models.iterator().next());
            }
            int currentRowIndex = sheet.getPhysicalNumberOfRows();
            for (Object model : models) {
                Row row = sheet.createRow(currentRowIndex++);
                row.setHeight((short)-1);
                this.writeModel(fieldMap, model, row);
            }
            for (int i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
                sheet.autoSizeColumn(i, true);
            }
            if (this.config.getFooterBuilder() != null) {
                this.config.getFooterBuilder().accept((Workbook)workbook, sheet);
            }
            workbook.write(outputStream);
        }
        catch (Exception e) {
            throw new ExcelModelException("An error occurred while writing file.", e);
        }
    }

    private <T> void writeHeader(Map<Annotation, Field> fieldMap, Row row, CellStyle cellStyle, T model) throws Exception {
        for (Map.Entry<Annotation, Field> entry : fieldMap.entrySet()) {
            if (entry.getKey() instanceof ExcelColumn) {
                ExcelColumn annotation = (ExcelColumn)entry.getKey();
                Field field = entry.getValue();
                Cell cell = row.createCell(annotation.index() - 1);
                cell.setCellValue(annotation.title() != null && !annotation.title().isBlank() ? annotation.title() : field.getName());
                if (cellStyle == null) continue;
                cell.setCellStyle(cellStyle);
                continue;
            }
            if (!(entry.getKey() instanceof ExcelObject)) continue;
            Field field = entry.getValue();
            this.writeHeader(fieldMap, row, cellStyle, field.get(model));
        }
    }

    private <T> void writeModel(Map<Annotation, Field> fieldMap, T model, Row row) throws Exception {
        for (Map.Entry<Annotation, Field> entry : fieldMap.entrySet()) {
            if (entry.getKey() instanceof ExcelColumn) {
                ExcelColumn annotation = (ExcelColumn)entry.getKey();
                Field field = entry.getValue();
                Cell cell = row.createCell(annotation.index() - 1);
                cell.setCellStyle(this.contentStyle);
                Object value = field.get(model);
                if (value == null) continue;
                cell.setCellValue(value.toString());
                continue;
            }
            if (!(entry.getKey() instanceof ExcelObject)) continue;
            Field field = entry.getValue();
            this.writeModel(fieldMap, field.get(model), row);
        }
    }
}

