/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import io.github.ferhas.excel_models.annotation.TypeConverter;
import io.github.ferhas.excel_models.converter.FieldConverter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class FieldConverterProvider {
    static final Map<Class<?>, FieldConverter<?>> converters = new HashMap();

    public static void registerAdditionalConverter(Class<? extends FieldConverter> converter) {
        FieldConverterProvider.addConverters(Set.of(converter));
    }

    public static void registerAdditionalConverters(Set<Class<? extends FieldConverter>> additionalConverters) {
        FieldConverterProvider.addConverters(additionalConverters);
    }

    private static void addConverters(Set<Class<? extends FieldConverter>> typesAnnotatedWith) {
        typesAnnotatedWith.forEach(clazz -> {
            TypeConverter annotation = clazz.getAnnotation(TypeConverter.class);
            for (Class<?> type : annotation.forTypes()) {
                try {
                    Constructor declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
                    declaredConstructor.setAccessible(true);
                    converters.put(type, (FieldConverter)declaredConstructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    String error = String.format("Failed to initialize converters mapping! Check classes annotated with %s", TypeConverter.class.getSimpleName());
                    throw new RuntimeException(error, e);
                }
            }
        });
    }

    static {
        Set typesAnnotatedWith = new Reflections(FieldConverterProvider.class.getPackage().getName(), new Scanner[0]).getSubTypesOf(FieldConverter.class);
        FieldConverterProvider.addConverters(typesAnnotatedWith);
    }
}

