/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import io.github.ferhas.excel_models.ExcelReaderValidator;
import io.github.ferhas.excel_models.FieldConverterProvider;
import io.github.ferhas.excel_models.annotation.ExcelColumn;
import io.github.ferhas.excel_models.annotation.ExcelObject;
import io.github.ferhas.excel_models.config.ExcelReaderConfig;
import io.github.ferhas.excel_models.converter.FieldConverter;
import io.github.ferhas.excel_models.exception.ExcelFieldParseException;
import io.github.ferhas.excel_models.exception.ExcelModelException;
import jakarta.validation.ValidationException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelReader {
    private final ExcelReaderConfig config;
    private final ExcelReaderValidator validator;

    public ExcelReader() {
        this(new ExcelReaderConfig());
    }

    public ExcelReader(ExcelReaderConfig config) {
        this.config = config;
        this.validator = new ExcelReaderValidator();
    }

    public <T> List<T> parse(@NonNull InputStream inputStream, Class<T> type) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return this.parse(inputStream, type, null);
    }

    public <T> List<T> parse(@NonNull InputStream inputStream, @NonNull Class<T> type, Consumer<T> afterParse) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        ArrayList<T> resultList = new ArrayList<T>();
        try (XSSFWorkbook workbook = new XSSFWorkbook(inputStream);){
            Sheet sheet = workbook.getSheetAt(this.config.getSheetIndex() - 1);
            for (int rowNum = this.config.getHeaderOffset(); rowNum < sheet.getPhysicalNumberOfRows(); ++rowNum) {
                Row row = sheet.getRow(rowNum);
                if (this.isRowEmpty(row)) continue;
                T model = this.parseModel(type, row);
                if (afterParse != null) {
                    afterParse.accept(model);
                }
                try {
                    this.validator.validate(model);
                }
                catch (ValidationException e) {
                    throw new ValidationException(String.format("Invalid value on row %s, %s", row.getRowNum() + 1, e.getMessage()));
                }
                resultList.add(model);
            }
        }
        catch (Exception e) {
            throw new ExcelModelException("An error occurred while reading file.", e);
        }
        finally {
            this.validator.close();
        }
        return resultList;
    }

    private boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.getStringCellValue() == null || cell.getStringCellValue().isBlank()) continue;
            return false;
        }
        return true;
    }

    private <T> T parseModel(Class<T> type, Row row) throws Exception {
        Map<Annotation, Field> fieldMap = FieldConverterProvider.getFieldMap(type, false);
        T model = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Map.Entry<Annotation, Field> entry : fieldMap.entrySet()) {
            if (entry.getKey() instanceof ExcelColumn) {
                ExcelColumn annotation = (ExcelColumn)entry.getKey();
                Cell cell = row.getCell(annotation.index() - 1);
                if (cell == null) continue;
                Field field = entry.getValue();
                field.set(model, this.getCellValue(cell, field, annotation));
                continue;
            }
            if (!(entry.getKey() instanceof ExcelObject)) continue;
            Field field = entry.getValue();
            Object nestedModel = this.parseModel(field.getType(), row);
            field.set(model, nestedModel);
        }
        return model;
    }

    private Object getCellValue(Cell cell, Field field, ExcelColumn annotation) {
        Object value = this.getValueByCellType(cell);
        return this.tryConvertOrDefault(field, annotation, value);
    }

    private Object getValueByCellType(Cell cell) {
        Object value;
        switch (cell.getCellType()) {
            case ERROR: 
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                if (!((String)value).isBlank()) break;
                value = null;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private Object tryConvertOrDefault(Field field, ExcelColumn annotation, Object value) {
        block4: {
            Class fieldType = field.getType().isEnum() ? Enum.class : field.getType();
            FieldConverter<?> fieldConverter = FieldConverterProvider.converters.get(fieldType);
            try {
                if (value != null) {
                    return fieldConverter != null ? fieldConverter.tryParse(field, annotation, value) : value;
                }
                if (annotation.defaultInvalidValues()) {
                    return fieldConverter.getDefaultValue();
                }
            }
            catch (Exception e) {
                if (annotation.suppressErrors()) break block4;
                throw new ExcelFieldParseException(String.format("Failed to parse '%s' into field '%s.%s'", value, field.getDeclaringClass().getSimpleName(), field.getName()), e);
            }
        }
        return null;
    }
}

