/*
 * Decompiled with CFR 0.152.
 */
package lindelt.either;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class Either<L, R> {
    public static <T, U> Function<T, Either<Exception, U>> lift(Function<? super T, ? extends U> function) throws NullPointerException {
        Objects.requireNonNull(function);
        return arg -> Either.of(() -> function.apply(arg));
    }

    public static <T, U> Function<T, Either<Throwable, U>> liftChecked(Function<? super T, ? extends U> function) throws NullPointerException {
        Objects.requireNonNull(function);
        return arg -> Either.ofChecked(() -> function.apply(arg));
    }

    public static <L, R> Either<L, R> right(final R right) throws NullPointerException {
        Objects.requireNonNull(right);
        return new Either<L, R>(){

            @Override
            public boolean isRight() {
                return true;
            }

            @Override
            public R getRight() throws NoSuchElementException {
                return right;
            }

            @Override
            public L getLeft() throws NoSuchElementException {
                throw new NoSuchElementException("Either does not hold a left value");
            }
        };
    }

    public static <L, R> Either<L, R> right(R right, Class<L> leftType) throws NullPointerException {
        return Either.right(right);
    }

    public static <L, R> Either<L, R> left(final L left) throws NullPointerException {
        Objects.requireNonNull(left);
        return new Either<L, R>(){

            @Override
            public boolean isRight() {
                return false;
            }

            @Override
            public R getRight() throws NoSuchElementException {
                throw new NoSuchElementException("Either does not hold a right value");
            }

            @Override
            public L getLeft() throws NoSuchElementException {
                return left;
            }
        };
    }

    public static <L, R> Either<L, R> left(L left, Class<R> rightType) throws NullPointerException {
        return Either.left(left);
    }

    public static <L, R> Either<L, R> of(Optional<? extends R> maybe, L fallback) throws NullPointerException {
        return maybe.isPresent() ? Either.right(maybe.get()) : Either.left(fallback);
    }

    public static <L, R> Either<L, R> of(Optional<? extends R> maybe, Supplier<? extends L> fallback) throws NullPointerException {
        return maybe.isPresent() ? Either.right(maybe.get()) : Either.left(fallback.get());
    }

    public static <R> Either<Exception, R> of(Supplier<? extends R> supplier) {
        Either<Object, R> result;
        try {
            result = Either.right(supplier.get());
        }
        catch (Exception e) {
            result = Either.left(e);
        }
        return result;
    }

    public static <R> Either<Throwable, R> ofChecked(Supplier<? extends R> supplier) {
        Either<Object, R> result;
        try {
            result = Either.right(supplier.get());
        }
        catch (Throwable e) {
            result = Either.left(e);
        }
        return result;
    }

    protected Either() {
    }

    public abstract boolean isRight();

    public boolean isLeft() {
        return !this.isRight();
    }

    public abstract R getRight() throws NoSuchElementException;

    public R getRightOr(R fallback) {
        return this.isRight() ? this.getRight() : fallback;
    }

    public R getRightOrElse(Supplier<? extends R> fallback) throws NullPointerException {
        return this.isRight() ? this.getRight() : fallback.get();
    }

    public <X extends Throwable> R getRightOrThrow(Supplier<? extends X> supplier) throws NullPointerException, X {
        if (this.isRight()) {
            return this.getRight();
        }
        throw (Throwable)supplier.get();
    }

    public Optional<R> maybeRight() {
        return this.isRight() ? Optional.of(this.getRight()) : Optional.empty();
    }

    public abstract L getLeft() throws NoSuchElementException;

    public L getLeftOr(L fallback) {
        return this.isLeft() ? this.getLeft() : fallback;
    }

    public L getLeftOrElse(Supplier<? extends L> fallback) throws NullPointerException {
        return this.isLeft() ? this.getLeft() : fallback.get();
    }

    public <X extends Throwable> L getLeftOrThrow(Supplier<? extends X> supplier) throws NullPointerException, X {
        if (this.isLeft()) {
            return this.getLeft();
        }
        throw (Throwable)supplier.get();
    }

    public Optional<L> maybeLeft() {
        return this.isLeft() ? Optional.of(this.getLeft()) : Optional.empty();
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> mapper) throws NullPointerException {
        return this.isRight() ? Either.right(mapper.apply(this.getRight())) : this;
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> mapper) throws NullPointerException {
        return this.isLeft() ? Either.left(mapper.apply(this.getLeft())) : this;
    }

    public <T> Either<L, T> applyRight(Either<? extends L, Function<? super R, ? extends T>> applicative) throws NullPointerException {
        Either result = applicative.isLeft() ? applicative : (this.isLeft() ? this : Either.right(((Function)applicative.getRight()).apply(this.getRight())));
        return result;
    }

    public <T> Either<T, R> applyLeft(Either<Function<? super L, ? extends T>, ? extends R> applicative) throws NullPointerException {
        Either result = applicative.isRight() ? applicative : (this.isRight() ? this : Either.left(((Function)applicative.getLeft()).apply(this.getLeft())));
        return result;
    }

    public <T> Either<L, T> flatMapRight(Function<? super R, ? extends Either<? extends L, ? extends T>> mapper) throws NullPointerException {
        return this.isRight() ? mapper.apply(this.getRight()) : this;
    }

    public <T> Either<T, R> flatMapLeft(Function<? super L, ? extends Either<? extends T, ? extends R>> mapper) throws NullPointerException {
        return this.isLeft() ? mapper.apply(this.getLeft()) : this;
    }

    public void consume(Consumer<? super L> leftConsumer, Consumer<? super R> rightConsumer) throws NullPointerException {
        if (this.isRight()) {
            rightConsumer.accept(this.getRight());
        } else {
            leftConsumer.accept(this.getLeft());
        }
    }

    public void consumeRight(Consumer<? super R> consumer) throws NullPointerException {
        this.consume(l -> {}, consumer);
    }

    public void consumeLeft(Consumer<? super L> consumer) throws NullPointerException {
        this.consume(consumer, r -> {});
    }

    public Stream<R> streamRight() {
        Stream.Builder<R> builder = Stream.builder();
        if (this.isRight()) {
            builder.accept(this.getRight());
        }
        return builder.build();
    }

    public Stream<L> streamLeft() {
        Stream.Builder<L> builder = Stream.builder();
        if (this.isLeft()) {
            builder.accept(this.getLeft());
        }
        return builder.build();
    }

    public <T> T fold(Function<? super L, ? extends T> leftFolder, Function<? super R, ? extends T> rightFolder) throws NullPointerException {
        return this.isRight() ? rightFolder.apply(this.getRight()) : leftFolder.apply(this.getLeft());
    }

    public <T> Optional<T> foldCast(Class<T> castType) throws NullPointerException {
        try {
            return Optional.of(castType.cast(this.isRight() ? this.getRight() : this.getLeft()));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Either other = (Either)obj;
        if (this.isRight() && other.isRight()) {
            return this.getRight().equals(other.getRight());
        }
        if (this.isLeft() && other.isLeft()) {
            return this.getLeft().equals(other.getLeft());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isLeft() ? this.getLeft().hashCode() : 0);
        result = 31 * result + (this.isRight() ? this.getRight().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Either." + (this.isLeft() ? "Left[" : "Right[") + (this.isLeft() ? this.getLeft() : this.getRight()) + "]";
    }
}

