/*
 * Decompiled with CFR 0.152.
 */
package lindelt.either;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import lindelt.either.Either;

public final class Eithers {
    public static <L extends Comparable<? super L>, R extends Comparable<? super R>> Comparator<Either<? extends L, ? extends R>> comparator(boolean reverseContents, boolean reverseDirection) {
        int dirMult = reverseDirection ? -1 : 1;
        int valMult = reverseContents ? -1 : 1;
        return (first, second) -> {
            Objects.requireNonNull(first);
            Objects.requireNonNull(second);
            int res = first.isRight() != second.isRight() ? dirMult * (first.isRight() ? 1 : -1) : (first.isRight() ? valMult * ((Comparable)first.getRight()).compareTo(second.getRight()) : valMult * ((Comparable)first.getLeft()).compareTo(second.getLeft()));
            return res;
        };
    }

    public static <L extends Comparable<? super L>, R extends Comparable<? super R>> Comparator<Either<? extends L, ? extends R>> nullableComparator(boolean reverseContents, boolean reverseDirection) {
        Comparator nonNull = Eithers.comparator(reverseContents, reverseDirection);
        return (first, second) -> {
            int res = first == null || second == null ? (first == second ? 0 : ((reverseDirection ? second : first) == null ? -1 : 1)) : nonNull.compare((Either)first, (Either)second);
            return res;
        };
    }

    public static <L, R> Partition<L, R> partition(Collection<? extends Either<? extends L, ? extends R>> eithers) throws NullPointerException {
        Partition res = new Partition();
        if (eithers != null) {
            res.nullCount = Eithers.partitionInto(eithers, res.getLefts(), res.getRights());
        }
        return res;
    }

    public static <L, R> void partitionInto(Collection<? extends Either<? extends L, ? extends R>> eithers, Partition<? super L, ? super R> partition) throws NullPointerException {
        if (eithers != null) {
            Objects.requireNonNull(partition);
            Partition<L, R> partition2 = partition;
            ((Partition)partition2).nullCount = ((Partition)partition2).nullCount + Eithers.partitionInto(eithers, partition.getLefts(), partition.getRights());
        }
    }

    public static <L, R> int partitionInto(Collection<? extends Either<? extends L, ? extends R>> eithers, Collection<? super L> lefts, Collection<? super R> rights) throws NullPointerException, UnsupportedOperationException, IllegalArgumentException, IllegalStateException {
        int[] res = new int[]{0};
        if (eithers == null) {
            return res[0];
        }
        Objects.requireNonNull(lefts);
        Objects.requireNonNull(rights);
        eithers.forEach(either -> {
            if (either == null) {
                res[0] = res[0] + 1;
            } else if (either.isRight()) {
                rights.add((Object)either.getRight());
            } else {
                lefts.add((Object)either.getLeft());
            }
        });
        return res[0];
    }

    public static class Partition<L, R> {
        private ArrayList<L> leftList = new ArrayList();
        private ArrayList<R> rightList = new ArrayList();
        private int nullCount = 0;

        protected Partition() {
        }

        public ArrayList<L> getLefts() {
            return this.leftList;
        }

        public ArrayList<R> getRights() {
            return this.rightList;
        }

        public int getNullCount() {
            return this.nullCount;
        }
    }
}

