/*
 * Decompiled with CFR 0.152.
 */
package io.github.xibalbaM.axiumApi;

import io.github.xibalbaM.axiumApi.Account;
import io.github.xibalbaM.axiumApi.Game;
import io.github.xibalbaM.axiumApi.PublicAccount;
import io.github.xibalbaM.axiumApi.RestResponse;
import io.github.xibalbaM.axiumApi.Role;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;

public class AxiumAPI {
    private static String API_URL = "https://axium-centrality.herokuapp.com/api";
    private static WebClient client = WebClient.create((String)API_URL);

    public static void setApiUrl(String API_URL) {
        AxiumAPI.API_URL = API_URL;
        client = WebClient.create((String)API_URL);
    }

    public static RestResponse<Account> login(String username, String password) {
        return AxiumAPI.doRequest("/user/connect?username=" + username + "&password=" + password, new ParameterizedTypeReference<RestResponse<Account>>(){});
    }

    public static RestResponse<Account> login(String token) {
        return AxiumAPI.doRequest("/user/tokenConnect?token=" + token, new ParameterizedTypeReference<RestResponse<Account>>(){});
    }

    public static RestResponse<PublicAccount> getAccountPublicInfos(String username) {
        return AxiumAPI.doRequest("/user/?username=" + username, new ParameterizedTypeReference<RestResponse<PublicAccount>>(){});
    }

    public static RestResponse<PublicAccount> getAccountPublicInfos(int id) {
        return AxiumAPI.doRequest("/user/?id=" + id, new ParameterizedTypeReference<RestResponse<PublicAccount>>(){});
    }

    public static RestResponse<Role> getRole(int id) {
        return AxiumAPI.doRequest("/api/roles/?id=" + id, new ParameterizedTypeReference<RestResponse<Role>>(){});
    }

    public static RestResponse<Role> getRole(String name) {
        return AxiumAPI.doRequest("/roles/?name=" + name, new ParameterizedTypeReference<RestResponse<Role>>(){});
    }

    public static RestResponse<Role[]> getRoles() {
        return AxiumAPI.doRequest("/roles/", new ParameterizedTypeReference<RestResponse<Role[]>>(){});
    }

    public static RestResponse<Game> getGame(int id) {
        return AxiumAPI.doRequest("/game/?id=" + id, new ParameterizedTypeReference<RestResponse<Game>>(){});
    }

    public static RestResponse<Game> getGame(String name) {
        return AxiumAPI.doRequest("/game/?name=" + name, new ParameterizedTypeReference<RestResponse<Game>>(){});
    }

    public static RestResponse<Game[]> getGames() {
        return AxiumAPI.doRequest("/game/", new ParameterizedTypeReference<RestResponse<Game[]>>(){});
    }

    public static <T> RestResponse<T> doRequest(String relativeUrl, ParameterizedTypeReference<RestResponse<T>> type) {
        WebClient.RequestBodyUriSpec uriSpec = client.method(HttpMethod.GET);
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(relativeUrl, new Object[0]);
        return (RestResponse)bodySpec.retrieve().bodyToMono(type).block();
    }
}

