/*
 * Decompiled with CFR 0.152.
 */
package org.auspicode.cml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.auspicode.cml.exception.WordOutOfReachException;
import org.auspicode.cml.utils.DateUtils;

public class ProcessLine {
    public static String extractValueAfterKeyword(@NonNull String line, String keyword, int index) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String[] lineAfterKeyword = line.split(keyword);
        String[] splitLine = lineAfterKeyword[1].trim().split(" ");
        ProcessLine.checkWordReach(splitLine, index);
        return splitLine[index].trim();
    }

    public static String extractAllValuesAfterKeyword(@NonNull String line, String keyword) {
        String[] splitLine;
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String result = "";
        String[] lineAfterKeyword = line.split(keyword);
        for (String str : splitLine = lineAfterKeyword[1].trim().split(" ")) {
            result = result.concat(str.trim()).concat(" ");
        }
        return result.trim();
    }

    public static String extractAllValuesAfterIndex(@NonNull String line, int index) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String result = "";
        String[] splitLine = line.trim().split(" ");
        for (int i = index + 1; i < splitLine.length; ++i) {
            result = result.concat(splitLine[i].trim()).concat(" ");
        }
        return result.trim();
    }

    public static String extractValue(@NonNull String line, int index) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String[] splitLine = line.trim().split(" ");
        ProcessLine.checkWordReach(splitLine, index);
        return splitLine[index].trim();
    }

    public static String extractSeveralValues(@NonNull String line, int ... index) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String result = "";
        String[] splitLine = line.trim().split(" ");
        for (int n : index) {
            ProcessLine.checkWordReach(splitLine, n);
            result = result.concat(splitLine[n].trim()).concat(" ");
        }
        return result.trim();
    }

    public static String excludeLastValue(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String result = "";
        String[] splitLine = line.trim().split(" ");
        for (int i = 0; i < splitLine.length - 1; ++i) {
            result = result.concat(splitLine[i].trim()).concat(" ");
        }
        return result.trim();
    }

    private static void checkWordReach(String[] wordArr, int n) {
        if (n > wordArr.length) {
            throw new WordOutOfReachException("Word out of reach");
        }
    }

    public static Double extractAmount(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        String result = "";
        Pattern pattern = Pattern.compile("(\\d+.\\d+)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            result = matcher.group().contains(",") ? matcher.group().replace(",", ".") : matcher.group();
        }
        return Double.valueOf(result);
    }

    public static Month extractMonth(String line, String dateFormat, int iterations) {
        return Month.of(ProcessLine.extractCalendar(line, dateFormat, iterations).get(2) + 1);
    }

    public static Year extractYear(String line, String dateFormat, int iterations) {
        return Year.of(ProcessLine.extractCalendar(line, dateFormat, iterations).get(1));
    }

    public static LocalDate extractDate(String line, String dateFormat, int iterations) {
        return LocalDate.ofInstant(ProcessLine.extractCalendar(line, dateFormat, iterations).toInstant(), ZoneId.systemDefault());
    }

    private static Calendar extractCalendar(@NonNull String line, String dateFormat, int iterations) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        Pattern pattern = Pattern.compile(DateUtils.createDateRegexPattern(dateFormat));
        Matcher matcher = pattern.matcher(line);
        for (int i = 0; i < iterations; ++i) {
            matcher.find();
        }
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(new SimpleDateFormat(dateFormat, Locale.ENGLISH).parse(matcher.group()));
        }
        catch (ParseException e) {
            System.out.println(e.getErrorOffset());
        }
        return cal;
    }

    private ProcessLine() {
    }
}

