/*
 * Decompiled with CFR 0.152.
 */
package org.auspicode.cml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.auspicode.cml.exception.KeywordNotFoundException;
import org.auspicode.cml.exception.LineOutOfReachException;
import org.auspicode.cml.exception.OffsetIsZeroException;

public class SearchLine {
    public static String withOffset(String text, String keyword, int offset) {
        if (offset == 0) {
            throw new OffsetIsZeroException("Offset parameter can't be 0");
        }
        String line = "";
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            int keywordLine = SearchLine.findKeywordLine(reader, keyword);
            if (offset > 0) {
                line = SearchLine.findByAmountOfLines(reader, offset);
            } else {
                reader.reset();
                line = SearchLine.findByAmountOfLines(reader, keywordLine + offset);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        if (line == null) {
            throw new LineOutOfReachException("Line out of reach");
        }
        return line;
    }

    private static String findByAmountOfLines(BufferedReader reader, int amountOfLines) throws IOException {
        for (int i = 1; i < amountOfLines; ++i) {
            reader.readLine();
        }
        return reader.readLine();
    }

    private static int findKeywordLine(BufferedReader reader, String keyword) throws IOException {
        int numberOfLinesRead = 1;
        String line = "";
        reader.mark(1);
        line = reader.readLine();
        while (!line.contains(keyword)) {
            line = reader.readLine();
            ++numberOfLinesRead;
            if (line != null) continue;
            throw new KeywordNotFoundException("Keyword you're looking for is not present in this file");
        }
        return numberOfLinesRead;
    }

    public static String withKeyword(String text, String keyword) {
        String line = "";
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            line = reader.readLine();
            while (!line.contains(keyword)) {
                line = reader.readLine();
                if (line != null) continue;
                throw new KeywordNotFoundException("Keyword you're looking for is not present in this file");
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return line;
    }

    private SearchLine() {
    }
}

