/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api.key;

import com.bitmart.api.common.CloudException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudSignature {
    private static final Logger log = LoggerFactory.getLogger(CloudSignature.class);
    static final String HMAC_SHA256 = "HmacSHA256";

    static String createSha256Signature(String key, String paraMap) {
        try {
            Mac sha256 = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), HMAC_SHA256);
            sha256.init(secretKeySpec);
            return Hex.encodeHexString((byte[])sha256.doFinal(paraMap.getBytes()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Signature create(String queryString, String apiSecret, String apiMemo) throws CloudException {
        try {
            String timestamp = String.valueOf(System.currentTimeMillis());
            return new Signature().setTimestamp(timestamp).setSign(CloudSignature.createSha256Signature(apiSecret, String.format("%s#%s#%s", timestamp, apiMemo, queryString)));
        }
        catch (Exception e) {
            log.info("create sign error", (Throwable)e);
            throw new CloudException("create signature failed");
        }
    }

    public static class Signature {
        private String timestamp;
        private String sign;

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getSign() {
            return this.sign;
        }

        public Signature setTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Signature setSign(String sign) {
            this.sign = sign;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$sign = this.getSign();
            String other$sign = other.getSign();
            return !(this$sign == null ? other$sign != null : !this$sign.equals(other$sign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Signature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
            return result;
        }

        public String toString() {
            return "CloudSignature.Signature(timestamp=" + this.getTimestamp() + ", sign=" + this.getSign() + ")";
        }
    }
}

