/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.websocket;

import com.bitmart.api.common.JsonUtils;
import com.bitmart.api.common.StringCompress;
import com.bitmart.websocket.WebSocketClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final WebSocketClientHandshaker handShaker;
    private final WebSocketClient webSocketClient;
    private ChannelPromise handshakeFuture;

    public WebSocketClientHandler(WebSocketClientHandshaker handShaker, WebSocketClient webSocketClient) {
        this.handShaker = handShaker;
        this.webSocketClient = webSocketClient;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handShaker.handshake(ctx.channel());
        log.info("WebSocket Client Connecting to {}", (Object)this.handShaker.uri().toString());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        log.info("WebSocket Client disconnected! {}", (Object)this.handShaker.uri().toString());
        if (this.webSocketClient.isClose()) {
            return;
        }
        EventLoop eventLoop = ctx.channel().eventLoop();
        eventLoop.schedule(() -> this.webSocketClient.reconnection(), 10L, TimeUnit.SECONDS);
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handShaker.isHandshakeComplete()) {
            try {
                this.handShaker.finishHandshake(ch, (FullHttpResponse)msg);
                log.info("WebSocket Client connected!");
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                log.info("WebSocket Client failed to connect");
                this.handshakeFuture.setFailure((Throwable)e);
            }
            return;
        }
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                String errorMessage;
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                String message = textFrame.text();
                if (this.webSocketClient.isPrint()) {
                    log.info("WebSocket Client received message:{}", (Object)message);
                }
                this.webSocketClient.callBack.onMessage(textFrame.text());
                String event = JsonUtils.fromJson(message, "event");
                if ("login".equals(event) && StringUtils.isNotBlank((CharSequence)(errorMessage = JsonUtils.fromJson(message, "errorMessage")))) {
                    this.webSocketClient.stop("login failed, errorMessage=" + errorMessage);
                }
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)frame;
                this.webSocketClient.callBack.onMessage(StringCompress.decode(binaryWebSocketFrame.content()));
            } else if (frame instanceof PongWebSocketFrame) {
                if (this.webSocketClient.isPrint()) {
                    log.info("WebSocket Client received pong");
                }
            } else if (frame instanceof CloseWebSocketFrame) {
                log.info("WebSocket Client received closing");
                ch.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

