/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    public static String toJson(Object obj) {
        Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{4}).create();
        return gson.toJson(obj);
    }

    public static String fromJson(String json, String field) {
        try {
            JsonObject asJsonObject;
            JsonElement jsonElement = JsonParser.parseString((String)json);
            if (jsonElement != null && jsonElement.isJsonObject() && (asJsonObject = jsonElement.getAsJsonObject()) != null && asJsonObject.has(field)) {
                return asJsonObject.get(field).getAsString();
            }
        }
        catch (Exception e) {
            log.warn("fromJson", (Throwable)e);
        }
        return null;
    }
}

